/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.EmitScope;
import apex.jorje.semantic.ast.visitor.InitializeUseBeforeDefinedVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.member.method.ConstructorCall;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.List;

public class ConstructorPreambleStatement
extends Statement {
    private static final Emit FINALLY_EMIT = emitter -> emitter.emit(Loc._SyntheticLoc(), SystemMethods.popTransparentFrame());
    private final Statement root;
    private final Loc loc;
    private List<Statement> classStatements;

    public ConstructorPreambleStatement(AstNode definingNode, Loc loc, Statement root) {
        super(definingNode);
        this.loc = loc;
        this.root = root;
        this.setReturnable(true);
    }

    private static Emit createInitPreamble(List<Statement> classStatements) {
        return emitter -> {
            TypeStack.TypeContext context = emitter.getTypeStack().peek();
            boolean pushTransparentFrame = context.getCodeUnitDetails().getVersion().isLessThan(Version.V178);
            if (pushTransparentFrame) {
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.pushTransparentFrame());
                emitter.getTryCatchFinallyStack().push(FINALLY_EMIT);
                emitter.getTryCatchFinallyStack().startTryBlock();
            }
            if (Version.V174.isGreaterThanOrEqual(context.getCodeUnitDetails().getVersion())) {
                InitializeUseBeforeDefinedVisitor visitor = new InitializeUseBeforeDefinedVisitor();
                EmitScope emitContext = new EmitScope(emitter);
                for (Statement statement : classStatements) {
                    statement.traverse(visitor, emitContext);
                }
            }
            for (Statement statement : classStatements) {
                statement.emit(emitter);
            }
            if (classStatements.isEmpty()) {
                emitter.emit(Loc._SyntheticLoc(), 0);
            }
            if (pushTransparentFrame) {
                emitter.getTryCatchFinallyStack().endBlock();
                emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
            }
        };
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        MethodInfo defaultConstructor;
        TypeInfo superType;
        this.classStatements = scope.getClassStatements();
        if (scope.getErrors().isInvalid(this.classStatements)) {
            scope.getErrors().markInvalid(this);
        }
        if (this.root.getConstructorCall() == ConstructorCall.NONE && (superType = this.getDefiningType().parents().superType()) != null && (defaultConstructor = superType.methods().get(SignatureFactory.create("<init>", TypeInfos.VOID))) == null) {
            scope.getErrors().markInvalid((AstNode)this, this.loc, I18nSupport.getLabel("invalid.default.constructor", superType));
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        TypeStack.TypeContext context = emitter.getTypeStack().peek();
        if (this.root.getConstructorCall() != ConstructorCall.THIS) {
            emitter.emitStatementExecuted(context.getLoc(), false, false);
            SystemModeEmit.builder().setType(context.getType()).setBody(ConstructorPreambleStatement.createInitPreamble(this.classStatements)).build().emit(emitter);
        }
        if (this.root == Statement.NOOP) {
            return;
        }
        Loc loc = emitter.getMethodStack().peek().getMethodInfo().getLoc();
        TypeInfo parentType = context.getType().parents().superType();
        if (this.root.getConstructorCall() == ConstructorCall.NONE) {
            if (ExceptionTypeInfoUtil.isException(emitter) && !emitter.getType().getCodeUnitDetails().isFileBased()) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.push(Loc._SyntheticLoc(), "Script-thrown exception");
                TypeInfo parentTypeToEmit = TypeInfoEquivalence.isEquivalent(parentType, InternalTypeInfos.APEX_EXCEPTION) ? TypeInfos.EXCEPTION : parentType;
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(parentTypeToEmit, TypeInfos.STRING));
                UserExceptionMethods.PUT_DEFAULT_MESSAGE.emit(emitter);
            } else if (!TypeInfoEquivalence.isEquivalent(InternalTypeInfos.APEX_OBJECT, parentType)) {
                emitter.emitVar(loc, 25, 0);
                emitter.emit(loc, ObjectMethods.constructor(parentType, new TypeInfo[0]));
            } else {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(InternalTypeInfos.APEX_OBJECT, new TypeInfo[0]));
            }
        } else {
            this.root.traverse(new AstVisitor<Scope>(){

                @Override
                public void visitEnd(BlockStatement node, Scope scope) {
                    node.emit(emitter, 0);
                }
            }, NoopScope.get());
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

