/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.FormalParameter;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;

public class CatchBlockStatement
extends Statement {
    private final Loc loc;
    private final FormalParameter exception;
    private final Statement statement;
    private final LocalVariableScope locals;
    private LocalInfo variable;

    public CatchBlockStatement(TryCatchFinallyBlockStatement definingNode, CatchBlock catchBlock) {
        super(definingNode);
        this.loc = Location.from(catchBlock.stmnt);
        this.exception = catchBlock.formalParameter;
        this.statement = AstNodeFactory.create((AstNode)this, catchBlock.stmnt);
        this.locals = new LocalVariableScope();
        this.setReturnable(this.statement);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        symbols.variables().push(this.locals);
        try {
            this.statement.validate(symbols, scope);
            if (scope.getErrors().isInvalid((AstNode)this.statement)) {
                scope.getErrors().markInvalid(this);
            }
            if (!this.variable.getType().isResolved()) {
                scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.variable.getType()));
            } else if (!ExceptionTypeInfoUtil.isException(this.getDefiningType(), this.variable.getType())) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.catch.exception", this.variable.getType()));
            }
        }
        finally {
            symbols.variables().pop();
        }
    }

    @Override
    public void emit(Emitter emitter) {
        TryCatchFinallyStack.TryCatchFinallyContext context = emitter.getTryCatchFinallyStack().peek();
        emitter.getTryCatchFinallyStack().startCatchBlock();
        TryCatchFinallyBlockStatement.UNCATCHABLE_EXCEPTION.emit(emitter);
        emitter.emitVar(this.loc, 58, this.variable.getPosition(emitter));
        this.statement.emit(emitter);
        TryCatchFinallyStack.Block block = emitter.getTryCatchFinallyStack().endBlock();
        emitter.emitJump(Loc._SyntheticLoc(), 167, context.exit);
        emitter.emitCatchBlock(context.tryStartForCatch, context.tryBlock.end, block.start, this.variable.getType());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public void createLocal(SymbolScope scope) {
        ModifierGroup modifiers = ModifierGroup.builder().setLoc(this.exception.name.loc).addAstModifiers(this.exception.modifiers).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build();
        TypeInfo type = scope.getSymbols().lookupTypeInfo(this.getDefiningType(), this.exception.type);
        this.variable = LocalInfo.builder().setName(this.exception.name.value).setDefiningType(this.getDefiningType()).setType(type).setModifiers(modifiers).build();
        scope.getErrors().addIfError((AstNode)this, this.exception.name.loc, scope.getSymbols().variables().add(this.variable));
    }

    public LocalInfo getVariable() {
        return this.variable;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }
}

