/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebServiceContextRule
implements AnnotationContextRule {
    private static final WebServiceContextRule INSTANCE = new WebServiceContextRule();

    private WebServiceContextRule() {
    }

    public static WebServiceContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        AnnotationRuleUtil.validate(context, ModifierTypeInfos.WEB_SERVICE, new Visitor(), new Visitor());
    }

    @Override
    public void validate(FieldContext context) {
        FieldInfo field = context.getFieldInfo();
        AnnotationRuleUtil.validate(context, ModifierTypeInfos.WEB_SERVICE, new Visitor());
        if (field.getType().getModifiers().has(AnnotationTypeInfos.DEPRECATED)) {
            context.addNodeError(I18nSupport.getLabel("webservice.deprecate.if.type.deprecated", field.getType()));
        }
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }

    private static class Visitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final Set<TypeInfo> visited = new HashSet<TypeInfo>();
        private final Map<TypeInfo, Boolean> isWebService = new HashMap<TypeInfo, Boolean>();

        private Visitor() {
        }

        private Boolean visitStandardType(TypeInfo type) {
            if (this.visited.contains(type)) {
                return true;
            }
            if (this.isWebService.containsKey(type)) {
                return this.isWebService.get(type);
            }
            if (type.getBytecodeName().startsWith("com/salesforce/api/") || !type.getModifiers().has(ModifierTypeInfos.GLOBAL) || AnnotationRuleUtil.isConnectApiAndNotBatchResult(type)) {
                return false;
            }
            this.visited.add(type);
            for (FieldInfo field : type.fields().all()) {
                if (!field.getModifiers().has(ModifierTypeInfos.WEB_SERVICE) || field.getType().accept(this).booleanValue()) continue;
                this.isWebService.put(type, false);
                return false;
            }
            this.isWebService.put(type, true);
            return true;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return this.visitStandardType(type);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            switch (type.getBasicType()) {
                case INTEGER: 
                case LONG: 
                case DOUBLE: 
                case DECIMAL: 
                case BOOLEAN: 
                case STRING: 
                case ID: 
                case BLOB: 
                case VOID: 
                case TIME: 
                case DATE: 
                case DATE_TIME: 
                case SOBJECT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return CollectionTypeInfoUtil.isList(type) ? CollectionTypeInfoUtil.getElementType(type).accept(this) : Boolean.valueOf(!CollectionTypeInfoUtil.isMap(type) && type.isResolved() && this.visitStandardType(type) != false);
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }
    }
}

