/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class InvocableContextRule
implements AnnotationContextRule {
    private static final InvocableContextRule INSTANCE = new InvocableContextRule();

    private InvocableContextRule() {
    }

    public static InvocableContextRule get() {
        return INSTANCE;
    }

    private static TypeInfoVisitor<Boolean> getMethodTypeVisitor() {
        return new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return false;
            }

            private Boolean visitUserType(TypeInfo type) {
                if (type.getModifiers().none(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC)) {
                    return false;
                }
                for (FieldInfo field : type.fields().all()) {
                    if (!field.getModifiers().has(AnnotationTypeInfos.INVOCABLE_VARIABLE)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                return true;
            }

            @Override
            public Boolean visit(StandardTypeInfo type) {
                return this.visitUserType(type);
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return CollectionTypeInfoUtil.isList(type) && type.acceptArguments(this);
            }

            @Override
            public Boolean visit(ScalarTypeInfo type) {
                return type.getBasicType().isScalarOrVoid();
            }

            @Override
            public Boolean visit(InternalTypeInfo type) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static TypeInfoVisitor<Boolean> getFieldTypeVisitor() {
        return new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                return true;
            }

            @Override
            public Boolean visit(StandardTypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return CollectionTypeInfoUtil.isList(type) && CollectionTypeInfoUtil.getElementType(type).accept(this) != false;
            }

            @Override
            public Boolean visit(ScalarTypeInfo type) {
                return type.getBasicType().isScalarOrVoid();
            }

            @Override
            public Boolean visit(InternalTypeInfo type) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void validate(MethodContext context) {
        MethodInfo method = context.getMethodInfo();
        if (context.getDefiningType().getUnitType() != UnitType.CLASS) {
            context.addNodeError(I18nSupport.getLabel("invocable.method.class.only"));
            return;
        }
        if (method.getModifiers().getAnnotations().size() != 1) {
            context.addNodeError(I18nSupport.getLabel("invocable.method.only"));
            return;
        }
        if (!method.getParameters().isEmpty()) {
            if (method.getParameters().size() > 1) {
                context.addNodeError(I18nSupport.getLabel("invocable.method.single.param"));
            } else if (method.getParameters().get(0).getType().getBasicType() != BasicType.LIST) {
                context.addNodeError(I18nSupport.getLabel("invocable.method.accepts.list.types", method.getParameters().get(0).getType()));
            }
        }
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.INVOCABLE_METHOD, InvocableContextRule.getMethodTypeVisitor(), InvocableContextRule.getMethodTypeVisitor());
    }

    @Override
    public void validate(FieldContext context) {
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.INVOCABLE_VARIABLE, InvocableContextRule.getFieldTypeVisitor());
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

