/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.VoidResult;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class AnnotationRuleUtil {
    static void validate(MethodContext context, ModifierOrAnnotationTypeInfo modifier, TypeInfoVisitor<Boolean> parameterTypeVisitor, TypeInfoVisitor<Boolean> returnTypeVisitor) {
        MethodInfo method = context.getMethodInfo();
        for (TypeInfo parameter : method.getParameterTypes()) {
            if (parameter.accept(parameterTypeVisitor).booleanValue()) continue;
            context.addNodeError(I18nSupport.getLabel("method.does.not.support.parameter.type", modifier, parameter));
        }
        if (!method.getReturnType().accept(returnTypeVisitor).booleanValue()) {
            context.addNodeError(I18nSupport.getLabel("method.does.not.support.return.type", modifier, method.getReturnType()));
        }
    }

    static void validate(FieldContext context, ModifierOrAnnotationTypeInfo modifier, TypeInfoVisitor<Boolean> visitor) {
        FieldInfo field = context.getFieldInfo();
        if (!field.getType().accept(visitor).booleanValue()) {
            context.addNodeError(I18nSupport.getLabel("field.does.not.support.type", modifier, field.getType()));
        }
    }

    public static Result<Void> validateHasTopLevelModifiers(Compilation compilation) {
        ModifierGroup modifiers;
        if (TypeInfoUtil.isTopLevel(compilation.getDefiningType()) && !(modifiers = compilation.getDefiningType().getModifiers()).has(ModifierTypeInfos.GLOBAL) && !modifiers.has(ModifierTypeInfos.PUBLIC) && !modifiers.has(AnnotationTypeInfos.IS_TEST)) {
            return VoidResult.error(I18nSupport.getLabel("toplevel.must.be.public.or.global"));
        }
        return VoidResult.of();
    }

    public static boolean isConnectApiAndNotBatchResult(TypeInfo type) {
        return Namespaces.CONNECT_API.equals(type.getNamespace()) && !type.getApexName().equals("BatchResult");
    }

    public static boolean hasConnectDeserializer(AccessEvaluator evaluator, TypeInfo type) {
        return type.getModifiers().has(AnnotationTypeInfos.USE_CONNECT_DESERIALIZER) && evaluator.hasConnectDeserializer(type);
    }

    public static boolean hasConnectSerializer(TypeInfo type) {
        return type.getModifiers().has(AnnotationTypeInfos.USE_CONNECT_SERIALIZER);
    }
}

