/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.property.rule;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.common.iterable.CaseInsensitiveSet;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;

public final class AnnotationPropertyRules {
    private AnnotationPropertyRules() {
    }

    public static AnnotationPropertyRule lessThanOrEqual(int value) {
        return new LessThanOrEqual(value);
    }

    public static AnnotationPropertyRule greaterThanOrEqual(int value) {
        return new GreaterThanOrEqual(value);
    }

    public static AnnotationPropertyRule validStrings(Set<String> values) {
        return new ValidStrings(CaseInsensitiveSet.builder().addAll(values).build());
    }

    public static AnnotationPropertyRule permGuardedString(String value, PlaceholderOrgPerm orgPerm) {
        return new PermGuardedString(value, orgPerm);
    }

    public static AnnotationPropertyRule permGuarded(PlaceholderOrgPerm orgPerm) {
        return new PermGuardedProperty(orgPerm);
    }

    public static AnnotationPropertyRule minVersion(Version version) {
        return new MinVersion(version);
    }

    public static AnnotationPropertyRule validApiVersion() {
        return new ValidApiVersion();
    }

    private static class GreaterThanOrEqual
    extends IntegerRule {
        private GreaterThanOrEqual(int value) {
            super(value);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            if (actual < this.getValue()) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.greater.than.or.equal", parameter.getProperty().getName(), parameter.getAnnotationType(), this.getValue(), actual));
            }
        }
    }

    private static class LessThanOrEqual
    extends IntegerRule {
        private LessThanOrEqual(int value) {
            super(value);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            if (actual > this.getValue()) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.less.than.or.equal", parameter.getProperty().getName(), parameter.getAnnotationType(), this.getValue(), actual));
            }
        }
    }

    private static class ValidApiVersion
    implements AnnotationPropertyRule {
        private ValidApiVersion() {
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return Collections.singleton(AnnotationProperty.Type.INTEGER);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            try {
                Version.fromInternal(actual);
            }
            catch (IllegalArgumentException x) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.invalid.api.version", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static abstract class IntegerRule
    implements AnnotationPropertyRule {
        private final int value;

        private IntegerRule(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return Collections.singleton(AnnotationProperty.Type.INTEGER);
        }
    }

    private static class PermGuardedString
    extends StringRule {
        private final String value;
        private final PlaceholderOrgPerm orgPerm;

        public PermGuardedString(String value, PlaceholderOrgPerm orgPerm) {
            this.value = value;
            this.orgPerm = orgPerm;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String actual = parameter.getStringValue();
            if (!context.getSymbols().getAccessEvaluator().hasPermission(this.orgPerm) && this.value.equalsIgnoreCase(actual)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.invalid.perm.value", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static class ValidStrings
    extends StringRule {
        private final Set<String> values;

        private ValidStrings(Set<String> values) {
            this.values = values;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String actual = parameter.getStringValue();
            if (!this.values.contains(actual)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.bad.string.value", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static abstract class StringRule
    implements AnnotationPropertyRule {
        private StringRule() {
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return Collections.singleton(AnnotationProperty.Type.STRING);
        }
    }

    private static class PermGuardedProperty
    implements AnnotationPropertyRule {
        private final PlaceholderOrgPerm orgPerm;

        private PermGuardedProperty(PlaceholderOrgPerm orgPerm) {
            this.orgPerm = orgPerm;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.copyOf(AnnotationProperty.Type.values());
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            if (!context.getSymbols().getAccessEvaluator().hasPermission(this.orgPerm) && Location.isReal(parameter.getLoc())) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.not.supported", parameter.getProperty().getName(), parameter.getAnnotationType()));
            }
        }
    }

    private static class MinVersion
    implements AnnotationPropertyRule {
        private final Version version;

        private MinVersion(Version version) {
            this.version = version;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.copyOf(AnnotationProperty.Type.values());
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            Version current = context.getVersion();
            if (Location.isReal(parameter.getLoc()) && !current.isGreaterThanOrEqual(this.version)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.min.version", parameter.getProperty().getName(), parameter.getAnnotationType(), this.version.toExternal()));
            }
        }
    }
}

