/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestModifierGroups;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import shaded.org.objectweb.asm.AnnotationVisitor;
import shaded.org.objectweb.asm.ClassWriter;
import shaded.org.objectweb.asm.FieldVisitor;
import shaded.org.objectweb.asm.MethodVisitor;

@PrepareForTest(value={ClassWriter.class, FieldVisitor.class, MethodVisitor.class})
public class ModifierGroupEmitTest
extends PowerMockTestCase {
    private static final ModifierGroup LOC_MODIFIERS = ModifierGroup.builder().setLoc(JadtTester.loc((int)1, (int)1, (int)10, (int)55)).build();
    private Emitter emitter;
    @Mock
    private ClassWriter classWriter;
    @Mock
    private FieldVisitor fieldWriter;
    @Mock
    private MethodVisitor methodWriter;
    @Mock
    private AnnotationVisitor annotationVisitor;
    @Mock
    private SourceFile source;

    @BeforeMethod
    public void setUp() throws Exception {
        PowerMockito.when((Object)this.classWriter, (String)"visitAnnotation", (Object[])new Object[]{InternalTypeInfos.SFDC_MODIFIERS.getTypeSignature(), true}).thenReturn((Object)this.annotationVisitor);
        PowerMockito.when((Object)this.fieldWriter, (String)"visitAnnotation", (Object[])new Object[]{InternalTypeInfos.SFDC_MODIFIERS.getTypeSignature(), true}).thenReturn((Object)this.annotationVisitor);
        PowerMockito.when((Object)this.methodWriter, (String)"visitAnnotation", (Object[])new Object[]{InternalTypeInfos.SFDC_MODIFIERS.getTypeSignature(), true}).thenReturn((Object)this.annotationVisitor);
        this.emitter = new Emitter();
    }

    private void visitAll(ModifierGroup modifiers, String developerName) {
        ModifierNode node = new ModifierNode(TestConstants.FOO, modifiers);
        this.emitter.getAnnotationVisitor().set(this.classWriter);
        node.emit(this.emitter);
        this.emitter.getAnnotationVisitor().unset();
        this.emitter.getAnnotationVisitor().set(this.fieldWriter);
        node.emit(this.emitter);
        this.emitter.getAnnotationVisitor().unset();
        this.emitter.getAnnotationVisitor().set(this.methodWriter, developerName);
        node.emit(this.emitter);
        this.emitter.getAnnotationVisitor().unset();
    }

    private void verifyNoSfdcModifier() {
        for (ModifierTypeInfo modifier : TypeInfoTables.MODIFIER_TYPES.values()) {
            ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)modifier.getBytecodeName()), Mockito.anyObject());
        }
    }

    @Test
    public void testNoAnnotationNeeded() {
        this.visitAll(TestModifierGroups.EMPTY, null);
        this.verifyNoSfdcModifier();
        ((ClassWriter)Mockito.verify((Object)this.classWriter, (VerificationMode)Mockito.times((int)0))).visitAnnotation(Mockito.anyString(), Mockito.anyBoolean());
        ((FieldVisitor)Mockito.verify((Object)this.fieldWriter, (VerificationMode)Mockito.times((int)0))).visitAnnotation(Mockito.anyString(), Mockito.anyBoolean());
        ((MethodVisitor)Mockito.verify((Object)this.methodWriter, (VerificationMode)Mockito.times((int)0))).visitAnnotation(Mockito.anyString(), Mockito.anyBoolean());
    }

    @Test
    public void testHasSfdcModifiers() {
        this.visitAll(ModifierGroups.STATEMENT_EXECUTED, null);
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)3))).visit(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED.getBytecodeName(), true);
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"developerName"), Mockito.anyObject());
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"line"), Mockito.anyObject());
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"column"), Mockito.anyObject());
    }

    @Test
    public void testHasLineNumber() {
        this.visitAll(LOC_MODIFIERS, null);
        this.verifyNoSfdcModifier();
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"developerName"), Mockito.anyObject());
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)3))).visit("line", 10);
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)3))).visit("column", 55);
    }

    @Test
    public void testHasDeveloperName() {
        this.visitAll(TestModifierGroups.EMPTY, "foobar");
        this.verifyNoSfdcModifier();
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)1))).visit("developerName", "foobar");
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"line"), Mockito.anyObject());
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"column"), Mockito.anyObject());
    }
}

