/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.Annotations;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ModifierGroupBuilder {
    private static final Function<ModifierTypeInfo, Modifier> TO_AST = type -> new Modifier(Loc._SyntheticLoc(), (ModifierTypeInfo)type);
    private final List<Modifier> modifiers;
    private final List<Annotation> annotations;
    private Loc loc = Loc._SyntheticLoc();

    ModifierGroupBuilder() {
        this.modifiers = new ArrayList<Modifier>();
        this.annotations = new ArrayList<Annotation>();
    }

    ModifierGroupBuilder addModifiers(List<Modifier> modifiers) {
        this.modifiers.addAll(modifiers);
        return this;
    }

    private void addModifiers(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    public ModifierGroupBuilder addModifiers(ModifierTypeInfo ... modifiers) {
        return this.addModifierTypes(Arrays.asList(modifiers));
    }

    public ModifierGroupBuilder addModifierTypes(List<ModifierTypeInfo> modifiers) {
        return this.addModifiers(modifiers.stream().map(TO_AST).collect(MoreIterables.toUnmodifiableList(modifiers.size())));
    }

    public ModifierGroupBuilder addIntersectionOfModifiers(ModifierGroup originalModifiers, ModifierTypeInfo ... modifiers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierTypeInfo modifier : modifiers) {
            if (!originalModifiers.has(modifier)) continue;
            builder.add(modifier);
        }
        return this.addModifierTypes((List<ModifierTypeInfo>)((Object)builder.build()));
    }

    private ModifierGroupBuilder removeModifiers(List<ModifierTypeInfo> modifiers) {
        block0: for (int i = 0; i < this.modifiers.size(); ++i) {
            for (ModifierTypeInfo removeModifier : modifiers) {
                if (!removeModifier.equals(this.modifiers.get(i).getModifierType())) continue;
                this.modifiers.remove(i);
                continue block0;
            }
        }
        return this;
    }

    public ModifierGroupBuilder removeModifiers(ModifierTypeInfo ... modifiers) {
        return this.removeModifiers(Arrays.asList(modifiers));
    }

    public ModifierGroupBuilder removeAllVisibilityModifiers() {
        return this.removeModifiers(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.PROTECTED, ModifierTypeInfos.PRIVATE);
    }

    public ModifierGroupBuilder addAnnotations(List<Annotation> annotations) {
        this.annotations.addAll(annotations);
        return this;
    }

    public ModifierGroupBuilder addAnnotation(Annotation annotations) {
        this.annotations.add(annotations);
        return this;
    }

    public ModifierGroupBuilder addAnnotationAndResolve(Modifier.Annotation ... annotations) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Modifier.Annotation annotation : annotations) {
            builder.add(Annotations.resolve(new Annotation(annotation)));
        }
        return this.addAnnotations((List<Annotation>)((Object)builder.build()));
    }

    public ModifierGroupBuilder addAstModifiers(apex.jorje.data.ast.Modifier ... value) {
        return this.addAstModifiers(Arrays.asList(value));
    }

    public ModifierGroupBuilder addAstModifiers(List<apex.jorje.data.ast.Modifier> modifiers) {
        for (apex.jorje.data.ast.Modifier modifier : AstNodeFactory.filterNotNull(modifiers)) {
            modifier._switch(new Modifier.SwitchBlock(){

                @Override
                public void _case(Modifier.TestMethodModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.TEST_METHOD));
                }

                @Override
                public void _case(Modifier.GlobalModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.GLOBAL));
                }

                @Override
                public void _case(Modifier.WebServiceModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.WEB_SERVICE));
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.GLOBAL));
                }

                @Override
                public void _case(Modifier.PublicModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.PUBLIC));
                }

                @Override
                public void _case(Modifier.PrivateModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.PRIVATE));
                }

                @Override
                public void _case(Modifier.ProtectedModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.PROTECTED));
                }

                @Override
                public void _case(Modifier.WithSharingModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.WITH_SHARING));
                }

                @Override
                public void _case(Modifier.WithoutSharingModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.WITHOUT_SHARING));
                }

                @Override
                public void _case(Modifier.StaticModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.STATIC));
                }

                @Override
                public void _case(Modifier.TransientModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.TRANSIENT));
                }

                @Override
                public void _case(Modifier.AbstractModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.ABSTRACT));
                }

                @Override
                public void _case(Modifier.FinalModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.FINAL));
                }

                @Override
                public void _case(Modifier.OverrideModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.OVERRIDE));
                }

                @Override
                public void _case(Modifier.VirtualModifier x) {
                    ModifierGroupBuilder.this.addModifiers(new Modifier(x.loc, ModifierTypeInfos.VIRTUAL));
                }

                @Override
                public void _case(Modifier.Annotation x) {
                    ModifierGroupBuilder.this.addAnnotation(AstNodeFactory.create(x));
                }
            });
        }
        return this;
    }

    public ModifierGroup build() {
        return new ModifierGroup(this);
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Loc getLoc() {
        return this.loc;
    }

    public ModifierGroupBuilder setLoc(Loc loc) {
        this.loc = loc;
        return this;
    }

    public int getJavaModifiers() {
        int javaModifiers = 0;
        for (Modifier modifier : this.modifiers) {
            javaModifiers |= modifier.getModifierType().getOpcode();
        }
        if ((javaModifiers & 1) > 0) {
            javaModifiers &= 0xFFFFFFFB;
            javaModifiers &= 0xFFFFFFFD;
        }
        if ((javaModifiers & 4) > 0) {
            javaModifiers &= 0xFFFFFFFD;
        }
        return javaModifiers;
    }
}

