/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.Locatable;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.visitor.ModifierOrAnnotationVisitor;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModifierGroup
implements Locatable {
    private final Loc loc;
    private final int javaModifiers;
    private final List<Annotation> annotations;
    private final List<Modifier> modifiers;
    private final Map<Equivalence.Wrapper<? extends TypeInfo>, ModifierOrAnnotation> all;
    private final Set<ModifierOrAnnotationTypeInfo> duplicates;
    private final Supplier<Set<ModifierOrAnnotationTypeInfo>> allTypes;
    private boolean resolved;

    ModifierGroup(ModifierGroupBuilder builder) {
        this.loc = builder.getLoc();
        this.javaModifiers = builder.getJavaModifiers();
        this.annotations = builder.getAnnotations();
        this.modifiers = builder.getModifiers();
        this.all = new LinkedHashMap<Equivalence.Wrapper<? extends TypeInfo>, ModifierOrAnnotation>();
        this.duplicates = new LinkedHashSet<ModifierOrAnnotationTypeInfo>();
        this.allTypes = Suppliers.memoize(new AllSupplier(this.all));
        this.resolve(this.modifiers);
        this.resolved = this.annotations.isEmpty();
    }

    public static ModifierGroupBuilder builder() {
        return new ModifierGroupBuilder();
    }

    private void resolve(List<? extends ModifierOrAnnotation> modifierOrAnnotations) {
        for (ModifierOrAnnotation modifierOrAnnotation : modifierOrAnnotations) {
            assert (modifierOrAnnotation.getType() != null);
            if (this.all.containsKey(modifierOrAnnotation.getType().getEquivalenceWrapper())) {
                this.duplicates.add(modifierOrAnnotation.getType());
                continue;
            }
            this.all.put(modifierOrAnnotation.getType().getEquivalenceWrapper(), modifierOrAnnotation);
        }
    }

    public int getJavaModifiers() {
        return this.javaModifiers;
    }

    public boolean has(ModifierOrAnnotationTypeInfo modifier) {
        return this.all.containsKey(modifier.getEquivalenceWrapper());
    }

    public boolean all(ModifierOrAnnotationTypeInfo ... modifiers) {
        assert (this.assertIsResolvedForInput(Arrays.asList(modifiers))) : "modifiers are not resolved";
        for (int i = 0; i < modifiers.length; ++i) {
            if (this.all.containsKey(modifiers[i].getEquivalenceWrapper())) continue;
            return false;
        }
        return true;
    }

    public boolean some(ModifierOrAnnotationTypeInfo ... modifiers) {
        return !this.none(Arrays.asList(modifiers));
    }

    public boolean not(ModifierOrAnnotationTypeInfo modifier) {
        return !this.has(modifier);
    }

    public boolean none(ModifierOrAnnotationTypeInfo ... modifiers) {
        return this.none(Arrays.asList(modifiers));
    }

    private boolean none(List<ModifierOrAnnotationTypeInfo> modifiers) {
        assert (this.assertIsResolvedForInput(modifiers));
        for (ModifierOrAnnotationTypeInfo modifier : modifiers) {
            if (!this.all.containsKey(modifier.getEquivalenceWrapper())) continue;
            return false;
        }
        return true;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isTest() {
        return this.some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST);
    }

    public boolean isTestOrTestSetup() {
        return this.some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST, AnnotationTypeInfos.TEST_SETUP);
    }

    public ModifierGroup resolve() {
        if (!this.resolved) {
            this.resolve(this.annotations);
        }
        this.resolved = true;
        return this;
    }

    public ModifierGroupBuilder copy() {
        return new ModifierGroupBuilder().setLoc(this.loc).addModifiers(this.modifiers).addAnnotations(this.annotations);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("loc", this.loc).add("javaModifiers", this.javaModifiers).add("allModifiers", this.all).toString();
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public Set<ModifierOrAnnotationTypeInfo> getDuplicates() {
        assert (this.resolved);
        return this.duplicates;
    }

    public Set<ModifierOrAnnotationTypeInfo> all() {
        assert (this.resolved);
        return this.allTypes.get();
    }

    public ModifierOrAnnotation get(ModifierOrAnnotationTypeInfo type) {
        assert (this.assertIsResolvedForInput(Collections.singletonList(type))) : "type is not resolved";
        return this.all.get(type.getEquivalenceWrapper());
    }

    private boolean assertIsResolvedForInput(List<ModifierOrAnnotationTypeInfo> modifiers) {
        if (this.resolved) {
            return true;
        }
        for (ModifierOrAnnotationTypeInfo modifier : modifiers) {
            boolean needsResolving = modifier.accept(new ModifierOrAnnotationVisitor<Boolean>(){

                @Override
                public Boolean visit(StandardAnnotationTypeInfo type) {
                    return true;
                }

                @Override
                public Boolean visit(ModifierTypeInfo type) {
                    return false;
                }
            });
            if (!needsResolving) continue;
            return false;
        }
        return true;
    }

    public Collection<ModifierOrAnnotation> allNodes() {
        return this.all.values();
    }

    private static class AllSupplier
    implements Supplier<Set<ModifierOrAnnotationTypeInfo>> {
        private final Map<Equivalence.Wrapper<? extends TypeInfo>, ModifierOrAnnotation> all;

        public AllSupplier(Map<Equivalence.Wrapper<? extends TypeInfo>, ModifierOrAnnotation> all) {
            this.all = all;
        }

        @Override
        public Set<ModifierOrAnnotationTypeInfo> get() {
            return TypeInfoEquivalence.unwrapSet(this.all.keySet());
        }
    }
}

