/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.EqualsBridge;
import apex.jorje.semantic.ast.member.bridge.HashCodeBridge;
import apex.jorje.semantic.ast.member.bridge.InheritanceBridge;
import apex.jorje.semantic.ast.member.bridge.InterfaceBridge;
import apex.jorje.semantic.ast.member.bridge.InterfaceErasedBridge;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class BridgeMethodCreator
implements AstNode {
    private static final Set<Bridge> BRIDGES = ImmutableSet.of(HashCodeBridge.get(), EqualsBridge.get(), InheritanceBridge.get(), InterfaceBridge.get(), InterfaceErasedBridge.get());
    private final List<Method> methods;
    private final Set<Bridge> bridges;
    private final TypeInfo definingType;
    private List<Method> bridgeMethods;

    public BridgeMethodCreator(AstNode definingNode, List<Method> methods) {
        this(definingNode, methods, BRIDGES);
    }

    BridgeMethodCreator(AstNode definingNode, List<Method> methods, Set<Bridge> bridges) {
        this.definingType = definingNode.getDefiningType();
        this.methods = methods;
        this.bridges = bridges;
    }

    public void createMethods(SymbolResolver symbols) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : this.methods) {
            if (!method.getMethodInfo().getGenerated().isUserDefined) continue;
            for (Bridge bridge : this.bridges) {
                if (!bridge.required(method.getMethodInfo())) continue;
                Method bridgeMethod = bridge.create(this, method.getMethodInfo());
                bridgeMethod.resolve(symbols);
                builder.add(bridgeMethod);
            }
        }
        this.bridgeMethods = builder.build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope) && this.bridgeMethods != null) {
            for (Method method : this.bridgeMethods) {
                method.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (Method method : this.bridgeMethods) {
            method.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        assert (this.bridgeMethods != null);
        for (Method method : this.bridgeMethods) {
            method.emit(emitter);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Loc getLoc() {
        return Loc._SyntheticLoc();
    }

    List<Method> getMethods() {
        return this.bridgeMethods;
    }
}

