/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.modifier.SharingTypeCalculator;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class SystemModeEmit
implements Emit {
    private final SharingType type;
    private final boolean emit;
    private final Emit body;
    private final boolean setupTestLimits;

    private SystemModeEmit(Builder builder) {
        this.type = builder.type;
        this.emit = builder.emit;
        this.body = builder.body;
        this.setupTestLimits = builder.setupTestLimits;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.setupTestLimits) {
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.setupTestLimits());
        }
        if (this.emit) {
            emitter.push(Loc._SyntheticLoc(), this.type.name());
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.pushSystemModeInherit());
            int originalValuePosition = emitter.getMethodStack().peek().getLocalVariables().add();
            emitter.emitVar(Loc._SyntheticLoc(), 58, originalValuePosition);
            emitter.getTryCatchFinallyStack().push(this.getFinallyEmitter(originalValuePosition));
            emitter.getTryCatchFinallyStack().startTryBlock();
        }
        this.body.emit(emitter);
        if (this.emit) {
            emitter.getTryCatchFinallyStack().endBlock();
            emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
        }
    }

    private Emit getFinallyEmitter(int originalValuePosition) {
        return emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, originalValuePosition);
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.popSystemModeInherit());
        };
    }

    public static class Builder {
        private SharingType type;
        private boolean emit;
        private Emit body;
        private boolean setupTestLimits = false;

        private Builder() {
        }

        public SystemModeEmit build() {
            assert (this.type != null);
            assert (this.body != null);
            return new SystemModeEmit(this);
        }

        public Builder setType(SharingType type) {
            assert (this.type == null);
            this.emit = true;
            this.type = type;
            return this;
        }

        public Builder setType(TypeInfo type) {
            assert (this.type == null);
            this.type = SharingTypeCalculator.get().resolve(type);
            this.emit = this.type != SharingType.INHERIT;
            return this;
        }

        public Builder setBody(Emit body) {
            assert (this.body == null);
            this.body = body;
            return this;
        }

        public Builder setBody(Statement body) {
            return this.setBody(body::emit);
        }

        public Builder setSetupTestLimits(boolean setupTestLimits) {
            this.setupTestLimits = setupTestLimits;
            return this;
        }
    }
}

