/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.PropertyGetter;
import apex.jorje.data.ast.PropertySetter;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.PropertyInfo;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestNode;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PropertyInfoTest {
    private static final SymbolResolver SYMBOLS = TestSymbolResolvers.createEmptySymbols();
    private static final PropertyGetter PROPERTY_GETTER = new PropertyGetter(JadtTester.NO_LOC, Optional.of(Modifier._PrivateModifier(JadtTester.NO_LOC)), Optional.empty());
    private static final PropertySetter PROPERTY_SETTER = new PropertySetter(JadtTester.NO_LOC, Optional.of(Modifier._PrivateModifier(JadtTester.NO_LOC)), Optional.empty());
    private static final AstNode NODE = TestNode.create(InternalTypeInfos.APEX_OBJECT);
    private PropertyDecl body;
    @Mock
    private PropertyInfo fooInfo;
    @Mock
    private PropertyInfo barInfo;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Optional<PropertyGetter> getter = Optional.of(PROPERTY_GETTER);
        Optional<PropertySetter> setter = Optional.of(PROPERTY_SETTER);
        this.body = new PropertyDecl(Lists.newArrayList(Modifier._AbstractModifier(JadtTester.NO_LOC)), JadtTester.INTEGER_TYPE, JadtTester.FOO_ID, getter, setter);
    }

    @Test
    public void testNewPropertyInfo() {
        Field field = new Field(NODE, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED));
        field.resolve(SYMBOLS);
        PropertyInfo info = new PropertyInfo(field, this.body, ModifierGroups.STATEMENT_EXECUTED, ModifierGroups.STATEMENT_EXECUTED, ModifierGroups.STATEMENT_EXECUTED);
        MatcherAssert.assertThat((Object)info.getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID));
        MatcherAssert.assertThat((Object)info.getDefiningType(), IsType.isType(InternalTypeInfos.APEX_OBJECT));
        MatcherAssert.assertThat((Object)info.getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)info.getLoc(), (Matcher)Matchers.is((Object)JadtTester.NO_LOC));
    }

    @Test
    public void testPropertyInfoNameComparator() {
        Mockito.when((Object)this.fooInfo.getName()).thenReturn((Object)JadtTester.FOO_ID);
        Mockito.when((Object)this.barInfo.getName()).thenReturn((Object)JadtTester.BAR_ID);
        List infoList = ImmutableList.of(this.fooInfo, this.barInfo).stream().sorted(PropertyInfo.NAME_COMPARATOR).collect(MoreIterables.toUnmodifiableList(2));
        MatcherAssert.assertThat(infoList, (Matcher)Matchers.contains((Object[])new PropertyInfo[]{this.barInfo, this.fooInfo}));
    }
}

