/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.semantic.ast.Locatable;
import apex.jorje.semantic.ast.member.AccessorFactory;
import apex.jorje.semantic.ast.member.AccessorModifierUtil;
import apex.jorje.semantic.ast.member.AccessorType;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.OldModifiers;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Comparator;
import java.util.List;

public class PropertyInfo
implements Locatable {
    public static final Comparator<PropertyInfo> NAME_COMPARATOR = (o1, o2) -> {
        String name2;
        String name1;
        if (o1 == null && o2 == null) {
            return 0;
        }
        String string = o1 == null ? null : (name1 = o1.getName() == null ? null : o1.getName().value);
        String string2 = o1 == null ? null : (name2 = o2.getName() == null ? null : o2.getName().value);
        return name1 == null ? 1 : (name2 == null ? -1 : name1.compareTo(name2));
    };
    private final Field underlyingField;
    private final Identifier name;
    private final PropertyDecl body;
    private final ModifierGroup propertyModifiers;
    private final ModifierGroup getterModifiers;
    private final ModifierGroup setterModifiers;

    public PropertyInfo(Field field, PropertyDecl body, ModifierGroup propertyModifiers, ModifierGroup getterModifiers, ModifierGroup setterModifiers) {
        this.underlyingField = field;
        this.name = body.name;
        this.body = body;
        this.propertyModifiers = propertyModifiers;
        this.getterModifiers = getterModifiers;
        this.setterModifiers = setterModifiers;
    }

    public String encode() {
        Default isDefaultSetter = this.isDefaultGetter();
        Default isDefaultGetter = this.isDefaultSetter();
        String accessorName = AccessorFactory.name(this.name.value);
        OldModifiers oldModifiers = this.getOldModifiers(isDefaultSetter, isDefaultGetter);
        return oldModifiers.getModifiers() + ":" + this.getLine() + ":" + this.getColumn() + ":" + this.name.value + ":" + accessorName + ":" + accessorName + ":" + isDefaultGetter.value + ":" + isDefaultSetter.value;
    }

    private OldModifiers getOldModifiers(Default isDefaultSetter, Default isDefaultGetter) {
        Result<List<ModifierTypeInfo>> result;
        OldModifiers oldModifiers = OldModifiers.fromModifiers(this.body.modifiers);
        switch (isDefaultGetter) {
            case YES: 
            case NO: {
                result = AccessorModifierUtil.calculateAccessorModifiers(AccessorType.GETTER, this.propertyModifiers, this.getterModifiers, this.getDefiningType().getCodeUnitDetails().getVersion());
                if (result.hasError()) break;
                if (result.get().contains(ModifierTypeInfos.LEGACY_DEFAULT_GETTER)) {
                    oldModifiers.set(OldModifiers.ModifierType.LegacyDefaultVisibilityGetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.GLOBAL)) {
                    oldModifiers.set(OldModifiers.ModifierType.GlobalGetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.PUBLIC)) {
                    oldModifiers.set(OldModifiers.ModifierType.PublicGetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.PROTECTED)) {
                    oldModifiers.set(OldModifiers.ModifierType.ProtectedGetter);
                    break;
                }
                if (!result.get().contains(ModifierTypeInfos.PRIVATE)) break;
                oldModifiers.set(OldModifiers.ModifierType.PrivateGetter);
                break;
            }
        }
        switch (isDefaultSetter) {
            case YES: 
            case NO: {
                result = AccessorModifierUtil.calculateAccessorModifiers(AccessorType.SETTER, this.propertyModifiers, this.setterModifiers, this.getDefiningType().getCodeUnitDetails().getVersion());
                if (result.hasError()) break;
                if (result.get().contains(ModifierTypeInfos.LEGACY_DEFAULT_GETTER)) {
                    oldModifiers.set(OldModifiers.ModifierType.LegacyDefaultVisibilitySetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.GLOBAL)) {
                    oldModifiers.set(OldModifiers.ModifierType.GlobalSetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.PUBLIC)) {
                    oldModifiers.set(OldModifiers.ModifierType.PublicSetter);
                    break;
                }
                if (result.get().contains(ModifierTypeInfos.PROTECTED)) {
                    oldModifiers.set(OldModifiers.ModifierType.ProtectedSetter);
                    break;
                }
                if (!result.get().contains(ModifierTypeInfos.PRIVATE)) break;
                oldModifiers.set(OldModifiers.ModifierType.PrivateSetter);
                break;
            }
        }
        switch (this.getDefiningType().getUnitType()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION: {
                break;
            }
            case ANONYMOUS: {
                oldModifiers.set(OldModifiers.ModifierType.StaticIdentifier);
            }
            case TRIGGER: {
                if (isDefaultGetter.value && isDefaultSetter.value) break;
                oldModifiers.set(OldModifiers.ModifierType.StaticIdentifier);
            }
        }
        return oldModifiers;
    }

    private Default isDefaultSetter() {
        return this.body.getter.map(value -> value.stmnt.map(ignored -> Default.NO).orElse(Default.YES)).orElse(Default.UNDEFINED);
    }

    private Default isDefaultGetter() {
        return this.body.setter.map(value -> value.stmnt.map(ignored -> Default.NO).orElse(Default.YES)).orElse(Default.UNDEFINED);
    }

    private int getColumn() {
        return this.body.name.loc.match(new Loc.MatchBlock<Integer>(){

            @Override
            public Integer _case(Loc.RealLoc x) {
                return x.column;
            }

            @Override
            public Integer _case(Loc.SyntheticLoc x) {
                return -1;
            }
        });
    }

    private int getLine() {
        return this.body.name.loc.match(new Loc.MatchBlock<Integer>(){

            @Override
            public Integer _case(Loc.RealLoc x) {
                return x.line;
            }

            @Override
            public Integer _case(Loc.SyntheticLoc x) {
                return -1;
            }
        });
    }

    public Identifier getName() {
        return this.name;
    }

    public TypeInfo getDefiningType() {
        return this.underlyingField.getFieldInfo().getDefiningType();
    }

    public TypeInfo getType() {
        return this.underlyingField.getFieldInfo().getType();
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    private static enum Default {
        NO(false),
        YES(true),
        UNDEFINED(true);

        private final boolean value;

        private Default(boolean value) {
            this.value = value;
        }
    }
}

