/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class ParameterUtilTest {
    @Test
    public void testCreateFromType() {
        Parameter parameter = Parameter.builder().setDefiningType(TestConstants.BAR).setType(TypeInfos.INTEGER).build();
        MatcherAssert.assertThat((Object)parameter.getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)parameter.getName().value, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)parameter.getName().loc, (Matcher)Matchers.is((Object)JadtTester.NO_LOC));
        MatcherAssert.assertThat((Object)parameter.getModifierInfo(), (Matcher)Matchers.is((Object)ModifierGroups.STATEMENT_EXECUTED));
    }

    @Test
    public void testCreateFromNameType() {
        Parameter parameter = Parameter.builder().setDefiningType(TestConstants.BAR).setName("foo").setType(TypeInfos.INTEGER).build();
        MatcherAssert.assertThat((Object)parameter.getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)parameter.getName().value, (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)parameter.getName().loc, (Matcher)Matchers.is((Object)JadtTester.NO_LOC));
        MatcherAssert.assertThat((Object)parameter.getModifierInfo(), (Matcher)Matchers.is((Object)ModifierGroups.STATEMENT_EXECUTED));
    }
}

