/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.MoreObjects;
import java.util.List;

public class Parameter
implements AstNode {
    private final TypeInfo definingType;
    private final Identifier name;
    private final TypeReference type;
    private final ModifierGroup modifiersInfo;
    private final ModifierNode modifiers;
    private final TypeInfo emitType;
    private LocalInfo variable;

    private Parameter(Builder builder) {
        this.definingType = builder.definingType;
        this.name = builder.name;
        this.type = builder.type;
        this.emitType = builder.emitType;
        this.modifiersInfo = builder.modifiers;
        this.modifiers = new ModifierNode(this, this.modifiersInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<TypeInfo> toType(List<Parameter> parameters) {
        return parameters.stream().map(Parameter::getType).collect(MoreIterables.toUnmodifiableList(parameters.size()));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("definingType", this.definingType).add("modifiers", this.modifiers).add("type", this.type).add("name", this.name).toString();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.modifiers.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!this.type.get().isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type.get()));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.definingType, this.type.get(), false)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
        }
        TypeInfo checkedType = MoreObjects.firstNonNull(this.emitType, this.type.get());
        if (Version.V168.isLessThanOrEqual(VersionUtil.get(this)) && TypeInfoEquivalence.isEquivalent(checkedType, TypeInfos.VOID)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.void.parameter"));
        }
        this.modifiers.validate(symbols, scope);
    }

    @Override
    public void emit(Emitter emitter) {
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    public void resolve(SymbolResolver symbols) {
        if (this.variable != null) {
            return;
        }
        this.variable = LocalInfo.builder().setName(this.getName()).setDefiningType(this.getDefiningType()).setType(this.type.resolve(symbols, this.getDefiningType())).setEmitType(this.emitType).setModifiers(this.getModifierInfo()).build();
    }

    public LocalInfo getVariable() {
        return this.variable;
    }

    public TypeInfo getType() {
        return this.type.get();
    }

    public ModifierGroup getModifierInfo() {
        return this.modifiersInfo;
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    public Identifier getName() {
        return this.name;
    }

    public TypeRef getTypeRef() {
        return this.type.getRef();
    }

    public static class Builder {
        private static final Identifier HIDDEN = Identifier._Identifier(Loc._SyntheticLoc(), null);
        private TypeInfo definingType;
        private Identifier name = HIDDEN;
        private TypeReference type;
        private ModifierGroup modifiers = ModifierGroups.STATEMENT_EXECUTED;
        private TypeInfo emitType = null;

        public Parameter build() {
            assert (this.definingType != null) : "no defining type provided";
            assert (this.type != null) : "no type provided";
            return new Parameter(this);
        }

        public Builder setDefiningType(TypeInfo definingType) {
            this.definingType = definingType;
            return this;
        }

        public Builder setType(TypeInfo type) {
            this.type = TypeReferences.createResolved(type);
            return this;
        }

        public Builder setType(TypeRef type) {
            this.type = TypeReferences.createResolvable(type);
            return this;
        }

        public Builder setName(String name) {
            this.name = Identifier._Identifier(Loc._SyntheticLoc(), name);
            return this;
        }

        public Builder setName(Identifier name) {
            this.name = name;
            return this;
        }

        public Builder setNoName(Loc loc) {
            this.name = Identifier._Identifier(loc, null);
            return this;
        }

        public Builder setModifiers(ModifierGroup modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder setEmitType(TypeInfo emitType) {
            this.emitType = emitType;
            return this;
        }
    }
}

