/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.ast.MethodDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;

public class MethodFactory {
    private MethodFactory() {
    }

    public static Method createUserMethod(AstNode definingNode, MethodDecl method) {
        return MethodFactory.createUserMethod(definingNode, ModifierGroup.builder().setLoc(method.name.loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(method.modifiers).build(), method);
    }

    public static Method createUserMethod(AstNode definingNode, ModifierGroup modifiers, MethodDecl method) {
        TypeInfo definingType = definingNode.getDefiningType();
        Statement root = method.stmnt.map(value -> AstNodeFactory.create(definingNode, value)).orElse(Statement.NOOP);
        ModifierGroupBuilder newModifiersBuilder = modifiers.copy();
        if ((definingType.getUnitType() == UnitType.TRIGGER || definingType.getUnitType() == UnitType.ANONYMOUS) && modifiers.not(ModifierTypeInfos.STATIC)) {
            newModifiersBuilder.addModifiers(ModifierTypeInfos.STATIC);
        }
        if (modifiers.has(ModifierTypeInfos.WEB_SERVICE) && modifiers.not(ModifierTypeInfos.GLOBAL)) {
            newModifiersBuilder.addModifiers(ModifierTypeInfos.GLOBAL);
        }
        ModifierGroup newModifiers = newModifiersBuilder.build();
        Generated generated = TypeInfoEquivalence.isEquivalent(InternalTypeInfos.APEX_EXCEPTION, definingType) || TypeInfoEquivalence.isEquivalent(InternalTypeInfos.APEX_OBJECT, definingType) ? Generated.SYSTEM : Generated.USER;
        return new Method(definingNode, StandardMethodInfo.builder().setDefiningType(definingType).setName(method.name).setFormalParameters(method.formalParameters.values).setReturnType(method.type).setModifiers(newModifiers).setGenerated(generated), root);
    }

    public static Method create(AstNode definingNode, StandardMethodInfoBuilder builder, Statement root) {
        return new Method(definingNode, builder, root);
    }
}

