/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.MethodEmit;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.MethodBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

public class Method
implements AstNode {
    public static final int MAX_PARAMETERS = 32;
    private final TypeInfo definingType;
    private final StandardMethodInfoBuilder builder;
    private final ModifierNode modifiers;
    private final LocalVariableScope locals;
    private final MethodBlockStatement body;
    private final ModifierGroup modifiersInfo;
    private MethodInfo methodInfo;

    Method(AstNode definingNode, StandardMethodInfoBuilder builder, Statement root) {
        this.definingType = definingNode.getDefiningType();
        this.builder = builder;
        this.modifiers = new ModifierNode(this, builder.getModifiers());
        this.modifiersInfo = builder.getModifiers();
        this.locals = new LocalVariableScope();
        this.body = new MethodBlockStatement(this, root);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            this.modifiers.traverse(visitor, scope);
            for (Parameter parameter : this.builder.getParameters()) {
                parameter.traverse(visitor, scope);
            }
            this.body.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            if (this.methodInfo.getGenerated().isUserDefined && !this.methodInfo.isConstructor()) {
                scope.getErrors().addIfError((AstNode)this, this.methodInfo.getLoc(), IdentifierValidator.get().validate(this.getDefiningType(), this.methodInfo.getIdentifier(), IdentifierValidator.Type.METHOD, false));
            }
            if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.methodInfo.getReturnType(), false)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.methodInfo.getReturnType()));
            }
            for (Parameter parameter : this.methodInfo.getParameters()) {
                parameter.validate(symbols, scope);
            }
            if (this.methodInfo.getParameters().size() > 32) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.number.parameters", 32));
                return;
            }
            this.modifiers.validate(symbols, scope);
            if (this.methodInfo.isConstructor() && this.methodInfo.getGenerated().isUserDefined && !this.getDefiningType().getCodeUnitDetails().getName().equalsIgnoreCase(this.builder.getInputName().value)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.constructor.name", this.builder.getInputName().value));
                return;
            }
            if (!this.modifiersInfo.has(ModifierTypeInfos.ABSTRACT)) {
                this.body.validate(symbols, scope);
                if (!this.body.isReturnable() && this.methodInfo.hasReturnValue()) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.return.non.void", this.methodInfo.getReturnType()));
                }
            } else if (this.body.hasBody()) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("abstract.methods.cannot.have.body", this.methodInfo.getReturnType()));
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public final void emit(Emitter emitter) {
        assert (this.methodInfo.getGenerated().isEmitted) : "method should not be emitted";
        Emit body = new Emit(){

            @Override
            public void emit(Emitter emitter) {
                TypeStack.TypeContext context = emitter.getTypeStack().peek();
                for (LocalInfo variable : Method.this.locals.all()) {
                    variable.getPosition(emitter);
                }
                if (!Method.this.modifiersInfo.has(ModifierTypeInfos.ABSTRACT)) {
                    if (!Method.this.modifiersInfo.isTestOrTestSetup() && ((Method)Method.this).methodInfo.getGenerated().emitAdditionalCodeLocations) {
                        emitter.emitAdditionalCodeLocation(Method.this.methodInfo.getLoc(), context.getType().getBytecodeName());
                    }
                    if ((TypeInfoUtil.isInTestClass(Method.this.methodInfo) || Method.this.modifiersInfo.isTest()) && ((Method)Method.this).methodInfo.getGenerated().isUserDefined) {
                        emitter.push(Loc._SyntheticLoc(), Method.this.modifiersInfo.isTest());
                        emitter.box(TypeInfos.BOOLEAN);
                        emitter.emit(Loc._SyntheticLoc(), SystemMethods.ensureTestContext());
                    }
                    if (((Method)Method.this).methodInfo.getGenerated().isUserDefined) {
                        SystemModeEmit.builder().setType(context.getType()).setBody(Method.this.body).setSetupTestLimits(!Method.this.methodInfo.isConstructor()).build().emit(emitter);
                    } else {
                        Method.this.body.emit(emitter);
                    }
                    if (!Method.this.body.isLastStatementReturn() && !Method.this.methodInfo.hasReturnValue()) {
                        emitter.emit(Loc._SyntheticLoc(), 177);
                    }
                }
            }
        };
        new MethodEmit(this.methodInfo, body).emit(emitter);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Loc getLoc() {
        return this.builder.getLoc();
    }

    public MethodInfo getMethodInfo() {
        assert (this.methodInfo != null) : "method hasn't been resolved: " + this.builder.getName();
        return this.methodInfo;
    }

    public void resolve(SymbolResolver symbols) {
        if (this.methodInfo != null) {
            return;
        }
        this.builder.getReturnType().resolve(symbols, this.getDefiningType());
        for (Parameter parameter : this.builder.getParameters()) {
            parameter.resolve(symbols);
        }
        this.methodInfo = this.builder.build();
    }

    public TypeRef getReturnTypeRef() {
        return this.builder.getReturnType().getRef();
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    public ModifierGroup getModifiers() {
        return this.modifiersInfo;
    }

    public ModifierNode getModifiersNode() {
        return this.modifiers;
    }
}

