/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestNode;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class FieldFactoryTest {
    private static final TypeInfo TYPE = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("foo")).buildResolved();
    private static final SymbolResolver SYMBOLS = TestSymbolResolvers.createEmptySymbols();
    private static final AstNode NODE = TestNode.create(TYPE);

    @Test
    public void testCreateFields() {
        List<Field> fields = FieldFactory.createEnumFields(NODE, ModifierGroups.STATEMENT_EXECUTED, Lists.newArrayList(JadtTester.FOO_ID, JadtTester.BAR_ID));
        MatcherAssert.assertThat(fields, (Matcher)Matchers.hasSize((int)2));
        fields.get(0).resolve(SYMBOLS);
        MatcherAssert.assertThat((Object)fields.get(0).getFieldInfo().getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        fields.get(1).resolve(SYMBOLS);
        MatcherAssert.assertThat((Object)fields.get(1).getFieldInfo().getName(), (Matcher)Matchers.is((Object)JadtTester.BAR_ID.value));
    }

    @Test
    public void testCreateFieldsJadt() {
        List<Field> fields = FieldFactory.createFields(NODE, VariableDecls._VariableDecls(JadtTester.EMPTY_MODIFIERS, JadtTester.INTEGER_TYPE, Lists.newArrayList(VariableDecl._VariableDecl(JadtTester.FOO_ID, Optional.empty()), VariableDecl._VariableDecl(JadtTester.BAR_ID, Optional.empty()))));
        MatcherAssert.assertThat(fields, (Matcher)Matchers.hasSize((int)2));
        fields.get(0).resolve(SYMBOLS);
        FieldInfo fooField = fields.get(0).getFieldInfo();
        MatcherAssert.assertThat((Object)fooField.getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)fooField.getType(), IsType.isType(TypeInfos.INTEGER));
        fields.get(1).resolve(SYMBOLS);
        FieldInfo barField = fields.get(1).getFieldInfo();
        MatcherAssert.assertThat((Object)barField.getName(), (Matcher)Matchers.is((Object)JadtTester.BAR_ID.value));
        MatcherAssert.assertThat((Object)barField.getType(), IsType.isType(TypeInfos.INTEGER));
    }
}

