/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.semantic.ast.member.AccessorType;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class AccessorModifierUtil {
    private AccessorModifierUtil() {
    }

    public static Result<List<ModifierTypeInfo>> calculateAccessorModifiers(AccessorType accessorType, ModifierGroup propertyModifiers, ModifierGroup accessorModifiers, Version version) {
        ModifierTypeInfo highestPropertyVisibility = Visibility.getHighestVisibilityModifier(propertyModifiers);
        ModifierTypeInfo highestAccessorVisibility = Visibility.getHighestVisibilityModifier(accessorModifiers);
        if (Visibility.getScore(accessorModifiers) > Visibility.getScore(propertyModifiers)) {
            return Result.error(I18nSupport.getLabel("illegal.accessor.on.property", highestAccessorVisibility, highestPropertyVisibility));
        }
        if (accessorModifiers.has(ModifierTypeInfos.GLOBAL)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.GLOBAL));
        }
        if (accessorModifiers.has(ModifierTypeInfos.PUBLIC)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PUBLIC));
        }
        if (accessorModifiers.has(ModifierTypeInfos.PROTECTED)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PROTECTED));
        }
        if (accessorModifiers.has(ModifierTypeInfos.PRIVATE)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PRIVATE));
        }
        if (propertyModifiers.has(ModifierTypeInfos.GLOBAL)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.GLOBAL));
        }
        if (propertyModifiers.has(ModifierTypeInfos.PUBLIC)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PUBLIC));
        }
        if (propertyModifiers.has(ModifierTypeInfos.PROTECTED)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PROTECTED));
        }
        if (propertyModifiers.has(ModifierTypeInfos.PRIVATE)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PRIVATE));
        }
        if (version.isGreaterThanOrEqual(Version.V156)) {
            return Result.of(ImmutableList.of(ModifierTypeInfos.PRIVATE));
        }
        switch (accessorType) {
            case GETTER: {
                return Result.of(ImmutableList.of(ModifierTypeInfos.PUBLIC, ModifierTypeInfos.LEGACY_DEFAULT_GETTER));
            }
            case SETTER: {
                return Result.of(ImmutableList.of(ModifierTypeInfos.PUBLIC, ModifierTypeInfos.LEGACY_DEFAULT_SETTER));
            }
        }
        throw new UnexpectedCodePathException("Unknown accessor type");
    }

    static ModifierGroup calculateGetterModifiers(Errors errors, ModifierGroup propertyModifiers, PropertyDecl body, Version version) {
        return body.getter.map(value -> AccessorModifierUtil.checkModifiers(AccessorType.GETTER, errors, propertyModifiers, AccessorModifierUtil.createModifiers(value.loc, value.modifier), version)).orElse(AccessorModifierUtil.removeVisibilityModifiers(propertyModifiers));
    }

    static ModifierGroup checkModifiers(AccessorType accessorType, Errors errors, ModifierGroup propertyModifiers, ModifierGroup accessorModifiers, Version version) {
        List<ModifierTypeInfo> additionalModifiers;
        ModifierGroupBuilder modifiers = propertyModifiers.copy().setLoc(Loc._SyntheticLoc());
        Result<List<ModifierTypeInfo>> calculatedModifier = AccessorModifierUtil.calculateAccessorModifiers(accessorType, propertyModifiers, accessorModifiers, version);
        if (calculatedModifier.hasError()) {
            errors.markInvalid(accessorModifiers.getLoc(), calculatedModifier.getError());
            additionalModifiers = Collections.singletonList(Visibility.getHighestVisibilityModifier(accessorModifiers));
        } else {
            additionalModifiers = calculatedModifier.get();
        }
        return modifiers.removeAllVisibilityModifiers().addModifierTypes(additionalModifiers).build();
    }

    static ModifierGroup calculateSetterModifiers(Errors errors, ModifierGroup propertyModifiers, PropertyDecl body, Version version) {
        return body.setter.map(value -> AccessorModifierUtil.checkModifiers(AccessorType.SETTER, errors, propertyModifiers, AccessorModifierUtil.createModifiers(value.loc, value.modifier), version)).orElse(AccessorModifierUtil.removeVisibilityModifiers(propertyModifiers));
    }

    private static ModifierGroup createModifiers(Loc loc, Optional<Modifier> modifier) {
        return modifier.map(value -> ModifierGroup.builder().setLoc(loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers((Modifier)value).build()).orElse(ModifierGroups.STATEMENT_EXECUTED);
    }

    private static ModifierGroup removeVisibilityModifiers(ModifierGroup propertyModifiers) {
        return propertyModifiers.copy().removeAllVisibilityModifiers().setLoc(Loc._SyntheticLoc()).addModifiers(ModifierTypeInfos.HIDDEN).build();
    }
}

