/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.VariableErrorMessageOverride;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableEmitLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableEmitStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableValidateStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import com.google.common.collect.Iterables;

public class VariableExpression
extends Expression {
    private final ReferenceExpression referenceExpression;
    private final Identifier name;
    private final Type type;
    private VariableVisitor.Context context;
    private Variable variable;

    private VariableExpression(AstNode definingNode, Expr.VariableExpr expr, Type type) {
        super(definingNode);
        this.type = type;
        this.referenceExpression = new ReferenceExpression(this, type.getReferenceType(), expr.dottedExpr, expr.names.subList(0, expr.names.size() - 1));
        this.name = Iterables.getLast(expr.names);
    }

    public static VariableExpression createStore(AstNode definingNode, Expr.VariableExpr expr) {
        return new VariableExpression(definingNode, expr, new Store());
    }

    public static VariableExpression createLoad(AstNode definingNode, Expr.VariableExpr expr) {
        return new VariableExpression(definingNode, expr, new Load());
    }

    @Override
    public final <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.referenceExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.referenceExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.referenceExpression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.variable = symbols.lookupVariableInfo(this.getDefiningType(), this.referenceExpression.getContext(), this.referenceExpression.getType(), this.name);
        if (this.variable == null) {
            scope.getErrors().markInvalid((AstNode)this, VariableErrorMessageOverride.get(symbols, this.getDefiningType(), this.referenceExpression.getType(), this.name.value));
            return;
        }
        if (this.variable.getType().isResolved()) {
            scope.getErrors().addIfError((AstNode)this, this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols, this.getDefiningType(), this.variable.getName(), this.variable.getModifiers(), this.variable.getMemberType()));
        }
        this.setType(this.variable.getType());
        this.context = new VariableVisitor.Context(this.name.loc);
        this.context.previous = this.referenceExpression.getContext();
        this.context.firstSObjectTypeInfo = this.referenceExpression.getFirstSObjectTypeInfo();
        this.context.isLast = true;
        this.type.additionalContextSetup(this, this.context);
        VariableVisitor visitor = this.type.createValidateVisitor(symbols, scope, this);
        this.variable.accept(visitor, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void emit(Emitter emitter) {
        boolean shouldReset = false;
        try {
            shouldReset = emitter.setVariableVisitor(new VariableEmitLoadVisitor(this, emitter));
            this.referenceExpression.emit(emitter);
            VariableVisitor visitor = this.type.createEmitVisitor(emitter, this);
            this.variable.accept(visitor, this.context);
        }
        finally {
            if (shouldReset) {
                emitter.setVariableVisitor(null);
            }
        }
    }

    @Override
    public final Loc getLoc() {
        return this.name.loc;
    }

    public final Variable getVariable() {
        return this.variable;
    }

    public final ReferenceExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    public final Identifier getIdentifier() {
        return this.name;
    }

    public ReferenceType getReferenceType() {
        return this.type.getReferenceType();
    }

    private static class Store
    implements Type {
        private Store() {
        }

        @Override
        public VariableVisitor createValidateVisitor(SymbolResolver symbols, ValidationScope scope, VariableExpression node) {
            return VariableValidateStoreVisitor.create(symbols, scope, node);
        }

        @Override
        public VariableVisitor createEmitVisitor(Emitter emitter, VariableExpression expression) {
            return new VariableEmitStoreVisitor(expression, emitter);
        }

        @Override
        public void additionalContextSetup(VariableExpression expression, VariableVisitor.Context context) {
            context.isInitialStore = expression.getOptions().isInitialStore;
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.STORE;
        }
    }

    private static class Load
    implements Type {
        private Load() {
        }

        @Override
        public VariableVisitor createValidateVisitor(SymbolResolver symbols, ValidationScope scope, VariableExpression node) {
            return VariableValidateLoadVisitor.create(symbols, scope, node);
        }

        @Override
        public VariableVisitor createEmitVisitor(Emitter emitter, VariableExpression expression) {
            return emitter.getVariableVisitor();
        }

        @Override
        public void additionalContextSetup(VariableExpression expression, VariableVisitor.Context context) {
            context.emitLast = true;
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.LOAD;
        }
    }

    private static interface Type {
        public VariableVisitor createValidateVisitor(SymbolResolver var1, ValidationScope var2, VariableExpression var3);

        public VariableVisitor createEmitVisitor(Emitter var1, VariableExpression var2);

        public void additionalContextSetup(VariableExpression var1, VariableVisitor.Context var2);

        public ReferenceType getReferenceType();
    }
}

