/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;

public class SuperVariableExpression
extends Expression {
    private final Loc loc;

    public SuperVariableExpression(AstNode definingNode, Expr.SuperVariableExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (symbols.staticContext().get()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.super.static.context"));
            return;
        }
        TypeInfo type = this.getDefiningType();
        TypeInfo superType = type.parents().superType();
        if (superType == null) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("no.super.type", type));
            return;
        }
        this.setType(superType);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitVar(this.loc, 25, 0);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

