/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.IllegalInstanceReferenceVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.ConstructorCall;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.MethodCallVisibility;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SuperMethodCallExpression
extends Expression {
    private final Loc loc;
    private final List<Expression> parameters;
    private MethodInfo method;

    public SuperMethodCallExpression(AstNode definingNode, Expr.SuperMethodCallExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
        this.parameters = AstNodeFactory.createExpressions(this, expr.inputParameters);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression parameter : this.parameters) {
                parameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : this.parameters) {
            expression.validate(symbols, scope);
            builder.add(expression.getType());
            if (scope.getErrors().isInvalid((AstNode)expression)) continue;
            expression.traverse(new IllegalInstanceReferenceVisitor(), scope);
        }
        ImmutableCollection parameterTypes = builder.build();
        if (scope.getErrors().isInvalid(this.parameters)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo type = this.getDefiningType();
        TypeInfo superType = type.parents().superType();
        if (superType == null || TypeInfoEquivalence.isEquivalent(superType, InternalTypeInfos.APEX_OBJECT)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("no.super.type", type));
            return;
        }
        Signature signature = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, (List<TypeInfo>)((Object)parameterTypes));
        Result<MethodInfo> result = symbols.lookupMethodInfo(this.getDefiningType(), IdentifierContext.OBJECT, superType, signature);
        if (scope.getErrors().addIfError((AstNode)this, result, I18nSupplier.create("invalid.constructor", signature))) {
            return;
        }
        this.method = result.get();
        List<String> visibilityErrors = MethodCallVisibility.calculate(this.getDefiningType(), symbols.getAccessEvaluator(), scope.isTestMethod(), this.method);
        if (!visibilityErrors.isEmpty()) {
            scope.getErrors().markInvalid((AstNode)this, visibilityErrors);
            return;
        }
        this.setConstructorCall(ConstructorCall.SUPER);
        if (!(!scope.isOutsideMethod() && scope.getMethod().isConstructor() && scope.isTopLevelBlock() && scope.isFirstStatementInBlock() && this.isTopLevel())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.super.call"));
            return;
        }
        this.setType(this.method.getReturnType());
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitVar(this.loc, 25, 0);
        for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(this.parameters, this.method.getParameterTypes())) {
            ((Expression)pair.left).emit(emitter);
            TypeConversion.emit(this.loc, emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
        }
        emitter.emit(this.loc, this.method.getAsmMethod());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public int getNumParameters() {
        return this.parameters.size();
    }
}

