/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Literal;
import apex.jorje.data.ast.PostfixOp;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.StringMethods;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.List;

class StringConcatenation {
    private static final int BIGGEST_APPEND_SIZE = 6;
    private static final int ESTIMATED_CONSTANT_STRING_MAX_LENGTH_ALLOWED = 21800;
    private final AstNode definingNode;
    private final Emitter emitter;

    public StringConcatenation(AstNode definingNode, Emitter emitter) {
        this.definingNode = definingNode;
        this.emitter = emitter;
    }

    public static void emitLiteral(LiteralExpression definingNode, Emitter emitter, String value) {
        if (value.length() >= 21800 && value.getBytes(Charset.forName("UTF-8")).length >= 65536) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int startIdx = 0; startIdx < value.length(); startIdx += 21800) {
                int endIdx = Math.min(startIdx + 21800, value.length());
                LiteralExpression newExpression = new LiteralExpression(definingNode, new Expr.LiteralExpr(Literal._StringLiteral(definingNode.getLoc(), value.substring(startIdx, endIdx))));
                newExpression.setType(TypeInfos.STRING);
                builder.add(newExpression);
            }
            StringConcatenation concatenation = new StringConcatenation(definingNode, emitter);
            concatenation.emit((List<Expression>)((Object)builder.build()));
        } else {
            emitter.push(definingNode.getLoc(), value);
        }
    }

    public void emit(List<Expression> allExpressions) {
        List<Expression> expressions = this.join(allExpressions);
        if (expressions.size() <= 36) {
            int outerAppends = (expressions.size() - 1) / 6 + 1;
            for (int i = 0; i < outerAppends; ++i) {
                int last = Math.min(expressions.size(), (i + 1) * 6);
                int innerAppends = last - i * 6;
                for (int j = i * 6; j < last; ++j) {
                    expressions.get(j).emit(this.emitter);
                    this.emitToString(expressions.get(j));
                }
                if (innerAppends <= 1) continue;
                this.emitter.emit(expressions.get(0).getLoc(), StringMethods.append(innerAppends));
            }
            if (outerAppends > 1) {
                this.emitter.emit(expressions.get(0).getLoc(), StringMethods.append(outerAppends));
            }
        } else {
            this.emitter.emitType(expressions.get(0).getLoc(), 187, ReifiedTypeInfos.STRING_LIST.getBytecodeName());
            this.emitter.emit(expressions.get(0).getLoc(), 89);
            this.emitter.emit(expressions.get(0).getLoc(), ObjectMethods.constructor(ReifiedTypeInfos.STRING_LIST, new TypeInfo[0]));
            for (Expression expression : expressions) {
                this.emitter.emit(expression.getLoc(), 89);
                expression.emit(this.emitter);
                this.emitToString(expression);
                this.emitter.emit(expression.getLoc(), ListMethods.addNoReturn(TypeInfos.LIST));
            }
            this.emitter.emit(expressions.get(0).getLoc(), StringMethods.join());
        }
    }

    private void emitToString(final Expression expression) {
        if (!expression.getType().equals(TypeInfos.STRING)) {
            expression.traverse(new AstVisitor<Scope>(){

                private void convertToInteger() {
                    TypeConversion.emit(expression.getLoc(), StringConcatenation.this.emitter, expression.getType(), TypeInfos.INTEGER);
                }

                @Override
                public void visitEnd(PrefixExpression node, Scope scope) {
                    node.getOp()._switch(new PrefixOp.SwitchBlockWithDefault(){

                        @Override
                        public void _case(PrefixOp.PrefixInc x) {
                            this.convertToInteger();
                        }

                        @Override
                        public void _case(PrefixOp.PrefixDec x) {
                            this.convertToInteger();
                        }

                        @Override
                        protected void _default(PrefixOp x) {
                        }
                    });
                }

                @Override
                public void visitEnd(PostfixExpression node, Scope scope) {
                    node.getOp()._switch(new PostfixOp.SwitchBlockWithDefault(){

                        @Override
                        public void _case(PostfixOp.PostfixInc x) {
                            this.convertToInteger();
                        }

                        @Override
                        public void _case(PostfixOp.PostfixDec x) {
                            this.convertToInteger();
                        }

                        @Override
                        protected void _default(PostfixOp x) {
                        }
                    });
                }
            }, NoopScope.get());
            this.emitter.emit(expression.getLoc(), StringMethods.valueOf());
        }
    }

    private boolean isStringLiteral(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(LiteralExpression node, ValueScope<Boolean> scope) {
                scope.setValue(node.getType().equals(TypeInfos.STRING));
            }
        }, false);
    }

    private List<Expression> join(List<Expression> expressions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (i < expressions.size()) {
            if (this.isStringLiteral(expressions.get(i))) {
                String value;
                StringBuilder sb = new StringBuilder();
                int firstExpressionIndex = i;
                while (i < expressions.size() && this.isStringLiteral(expressions.get(i)) && (value = (String)ExpressionUtil.getLiteralExpression(expressions.get(i)).getLiteral()).length() + sb.length() <= 21800) {
                    sb.append(value);
                    ++i;
                }
                LiteralExpression newExpression = new LiteralExpression(this.definingNode, new Expr.LiteralExpr(Literal._StringLiteral(expressions.get(firstExpressionIndex).getLoc(), sb.toString())));
                newExpression.setType(TypeInfos.STRING);
                builder.add(newExpression);
                continue;
            }
            builder.add(expressions.get(i++));
        }
        return builder.build();
    }
}

