/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import shaded.org.objectweb.asm.Label;

public class PrefixExpression
extends Expression {
    private final PrefixOp op;
    private final Loc loc;
    private final Expression expression;
    private final Expression store;

    public PrefixExpression(AstNode definingNode, final Expr.PrefixExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Location.from(expr);
        this.expression = expr.op.match(new PrefixOp.MatchBlockWithDefault<Expression>(){

            @Override
            public Expression _case(PrefixOp.PrefixInc x) {
                return AstNodeFactory.create((AstNode)PrefixExpression.this, expr.expr);
            }

            @Override
            public Expression _case(PrefixOp.PrefixDec x) {
                return AstNodeFactory.create((AstNode)PrefixExpression.this, expr.expr);
            }

            @Override
            protected Expression _default(PrefixOp x) {
                return AstNodeFactory.create((AstNode)PrefixExpression.this, expr.expr);
            }
        });
        this.store = expr.op.match(new PrefixOp.MatchBlockWithDefault<Expression>(){

            @Override
            public Expression _case(PrefixOp.PrefixInc x) {
                return AstNodeFactory.createStore(PrefixExpression.this, expr.expr);
            }

            @Override
            public Expression _case(PrefixOp.PrefixDec x) {
                return AstNodeFactory.createStore(PrefixExpression.this, expr.expr);
            }

            @Override
            protected Expression _default(PrefixOp x) {
                return Expression.NOOP;
            }
        });
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(final SymbolResolver symbols, final ValidationScope scope) {
        final boolean isSpecialAssignment = Version.V192.isLessThanOrEqual(VersionUtil.get(this));
        this.op._switch(new PrefixOp.SwitchBlockWithDefault(){

            @Override
            public void _case(PrefixOp.PrefixInc x) {
                ((PrefixExpression)PrefixExpression.this).expression.getOptions().isSpecialAssignment = isSpecialAssignment;
                ((PrefixExpression)PrefixExpression.this).store.getOptions().isSpecialAssignment = isSpecialAssignment;
            }

            @Override
            public void _case(PrefixOp.PrefixDec x) {
                ((PrefixExpression)PrefixExpression.this).expression.getOptions().isSpecialAssignment = isSpecialAssignment;
                ((PrefixExpression)PrefixExpression.this).store.getOptions().isSpecialAssignment = isSpecialAssignment;
            }

            @Override
            protected void _default(PrefixOp x) {
            }
        });
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.store.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.store)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(this.expression.getType());
        this.op._switch(new PrefixOp.SwitchBlockWithDefault(){

            @Override
            public void _case(PrefixOp.Positive x) {
            }

            @Override
            public void _case(PrefixOp.Negative x) {
                if (!PrefixExpression.this.getType().getBasicType().isNumber()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.negate.prefix.operand"));
                }
            }

            @Override
            public void _case(PrefixOp.Not x) {
                if (PrefixExpression.this.getType().getBasicType() == BasicType.NULL || !Distance.get().canAssign(PrefixExpression.this.getDefiningType(), PrefixExpression.this.getType(), (TypeInfo)TypeInfos.BOOLEAN)) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.boolean.prefix.operand", PrinterUtil.get().getFactory().prefixOpPrinter().print(x, new PrintContext())));
                }
            }

            @Override
            public void _case(PrefixOp.BitwiseComplement x) {
                if (!PrefixExpression.this.getType().getBasicType().isIntegerOrLong()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.type.bitwise.negate", PrefixExpression.this.getType()));
                }
            }

            @Override
            public void _case(PrefixOp.PrefixInc x) {
                if (!PrefixExpression.this.getType().getBasicType().isNumber()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.numeric.prefix.increment", PrefixExpression.this.getType()));
                }
            }

            @Override
            public void _case(PrefixOp.PrefixDec x) {
                if (!PrefixExpression.this.getType().getBasicType().isNumber()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.numeric.prefix.decrement", PrefixExpression.this.getType()));
                }
            }

            @Override
            public void _case(PrefixOp.Cast x) {
                TypeInfo type = symbols.lookupTypeInfo(PrefixExpression.this.getDefiningType(), x.type);
                if (!type.isResolved()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, PrefixExpression.this.getLoc(), UnresolvedErrorCalculator.getErrors(type));
                    return;
                }
                if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), PrefixExpression.this.getDefiningType(), type, scope.isTestMethod())) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("type.not.visible", type));
                    return;
                }
                if (!PrefixExpression.this.expression.getType().getBasicType().canBeCastOrInstanceOf()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.cast.type", PrefixExpression.this.expression.getType()));
                    return;
                }
                if (Distance.get().getCommonType(PrefixExpression.this.getDefiningType(), PrefixExpression.this.expression.getType(), type) == null && PrefixExpression.this.expression.getType().getUnitType() != UnitType.INTERFACE && type.getUnitType() != UnitType.INTERFACE) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("incompatible.cast.types", PrefixExpression.this.expression.getType(), type));
                }
                PrefixExpression.this.setType(type);
            }

            @Override
            protected void _default(PrefixOp x) {
                if (!PrefixExpression.this.getType().getBasicType().isNumber()) {
                    scope.getErrors().markInvalid((AstNode)PrefixExpression.this, I18nSupport.getLabel("invalid.numeric.prefix.operand", PrinterUtil.get().getFactory().prefixOpPrinter().print(x, new PrintContext())));
                }
            }
        });
    }

    @Override
    public void emit(final Emitter emitter) {
        this.op._switch(new PrefixOp.SwitchBlock(){
            private PrefixOp op;

            @Override
            public void _case(PrefixOp.Positive x) {
                PrefixExpression.this.expression.emit(emitter);
            }

            @Override
            public void _case(PrefixOp.Negative x) {
                PrefixExpression.this.expression.emit(emitter);
                emitter.unbox(PrefixExpression.this.getType());
                switch (PrefixExpression.this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(PrefixExpression.this.loc, DecimalMethods.negate());
                        break;
                    }
                    case DOUBLE: {
                        emitter.emit(PrefixExpression.this.loc, 119);
                        break;
                    }
                    case LONG: {
                        emitter.emit(PrefixExpression.this.loc, 117);
                        break;
                    }
                    case INTEGER: {
                        emitter.emit(PrefixExpression.this.loc, 116);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                emitter.box(PrefixExpression.this.getType());
            }

            @Override
            public void _case(PrefixOp.Not x) {
                Label trueLabel = new Label();
                Label exit = new Label();
                PrefixExpression.this.expression.emit(emitter);
                emitter.unbox(PrefixExpression.this.getType());
                emitter.emitJump(PrefixExpression.this.loc, 154, trueLabel);
                emitter.push(PrefixExpression.this.loc, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emitJump(PrefixExpression.this.loc, 167, exit);
                emitter.emit(trueLabel);
                emitter.push(PrefixExpression.this.loc, false);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(exit);
            }

            @Override
            public void _case(PrefixOp.BitwiseComplement x) {
                PrefixExpression.this.expression.emit(emitter);
                emitter.unbox(PrefixExpression.this.getType());
                switch (PrefixExpression.this.getType().getBasicType()) {
                    case LONG: {
                        emitter.push(PrefixExpression.this.loc, -1L);
                        emitter.emit(PrefixExpression.this.loc, 131);
                        break;
                    }
                    case INTEGER: {
                        emitter.emit(PrefixExpression.this.loc, 2);
                        emitter.emit(PrefixExpression.this.loc, 130);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                emitter.box(PrefixExpression.this.getType());
            }

            @Override
            public void _case(PrefixOp.PrefixInc x) {
                PrefixExpression.this.expression.emit(emitter);
                switch (PrefixExpression.this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(PrefixExpression.this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(PrefixExpression.this.loc, emitter, TypeInfos.INTEGER, PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, DecimalMethods.add());
                        break;
                    }
                    case DOUBLE: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 15);
                        emitter.emit(PrefixExpression.this.loc, 99);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    case LONG: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 10);
                        emitter.emit(PrefixExpression.this.loc, 97);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    case INTEGER: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 4);
                        emitter.emit(PrefixExpression.this.loc, 96);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                if (!PrefixExpression.this.isTopLevel()) {
                    emitter.emit(PrefixExpression.this.loc, 89);
                }
                PrefixExpression.this.store.emit(emitter);
            }

            @Override
            public void _case(PrefixOp.PrefixDec x) {
                PrefixExpression.this.expression.emit(emitter);
                switch (PrefixExpression.this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(PrefixExpression.this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(PrefixExpression.this.loc, emitter, TypeInfos.INTEGER, PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, DecimalMethods.subtract());
                        break;
                    }
                    case DOUBLE: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 15);
                        emitter.emit(PrefixExpression.this.loc, 103);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    case LONG: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 10);
                        emitter.emit(PrefixExpression.this.loc, 101);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    case INTEGER: {
                        emitter.unbox(PrefixExpression.this.getType());
                        emitter.emit(PrefixExpression.this.loc, 4);
                        emitter.emit(PrefixExpression.this.loc, 100);
                        emitter.box(PrefixExpression.this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                if (!PrefixExpression.this.isTopLevel()) {
                    emitter.emit(PrefixExpression.this.loc, 89);
                }
                PrefixExpression.this.store.emit(emitter);
            }

            @Override
            public void _case(PrefixOp.Cast x) {
                PrefixExpression.this.expression.emit(emitter);
                TypeConversion.emitOrCheckCast(PrefixExpression.this.loc, emitter, PrefixExpression.this.expression.getType(), PrefixExpression.this.getType());
            }
        });
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public PrefixOp getOp() {
        return this.op;
    }
}

