/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.MethodCallVisibility;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrinterUtil;
import java.util.List;

public class NewObjectExpression
extends Expression {
    private final Loc loc;
    private final TypeRef typeRef;
    private final List<Expression> parameters;
    private TypeInfo type;
    private MethodInfo constructor;

    public NewObjectExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.NormalObjectCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.typeRef = x.type;
        this.parameters = AstNodeFactory.createExpressions(this, x.inputParameters);
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression expression : this.parameters) {
                expression.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(final SymbolResolver symbols, final ValidationScope scope) {
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, scope.isTestMethod())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        if (this.type.getModifiers().has(ModifierTypeInfos.ABSTRACT)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.new.abstract", this.type));
            return;
        }
        this.type.accept(new TypeInfoVisitor.Default<Void>(){

            @Override
            protected Void _default(TypeInfo type) {
                I18nSupplier provider;
                List<TypeInfo> parameterTypes = NewObjectExpression.this.parameters.stream().map(expression -> {
                    expression.validate(symbols, scope);
                    return expression.getType();
                }).collect(MoreIterables.toUnmodifiableList(NewObjectExpression.this.parameters.size()));
                if (scope.getErrors().isInvalid(NewObjectExpression.this.parameters)) {
                    scope.getErrors().markInvalid(NewObjectExpression.this);
                    return null;
                }
                Signature signature = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, parameterTypes);
                Result<MethodInfo> result = symbols.lookupMethodInfo(NewObjectExpression.this.getDefiningType(), IdentifierContext.NONE, type, signature);
                I18nSupplier i18nSupplier = provider = TypeInfoUtil.isConstructable(type) ? I18nSupplier.create("unknown.constructor", type.toString(), signature.getSignatureParameters()) : I18nSupplier.create("type.not.constructable", type);
                if (scope.getErrors().addIfError((AstNode)NewObjectExpression.this, result, provider)) {
                    return null;
                }
                NewObjectExpression.this.constructor = result.get();
                List<String> visibilityErrors = MethodCallVisibility.calculate(NewObjectExpression.this.getDefiningType(), symbols.getAccessEvaluator(), scope.isTestMethod(), NewObjectExpression.this.constructor);
                if (!visibilityErrors.isEmpty()) {
                    scope.getErrors().markInvalid((AstNode)NewObjectExpression.this, visibilityErrors);
                }
                return null;
            }

            private void validateComponents() {
                if (!NewObjectExpression.this.parameters.isEmpty()) {
                    scope.getErrors().markInvalid((AstNode)NewObjectExpression.this, I18nSupport.getLabel("invalid.normal.constructor", NewObjectExpression.this.type));
                }
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                if (TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.SOBJECT_AGGREGATE_RESULT)) {
                    scope.getErrors().markInvalid((AstNode)NewObjectExpression.this, I18nSupport.getLabel("sobject.not.constructable", type));
                }
                this.validateComponents();
                return null;
            }

            @Override
            public Void visit(VfComponentTypeInfo type) {
                this.validateComponents();
                return null;
            }
        });
        this.setType(this.type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.type.accept(new TypeInfoVisitor.Default<Void>(){

            private void visitDynamicTypeInfo(TypeInfo type) {
                emitter.emitType(NewObjectExpression.this.loc, 187, type);
                emitter.emit(NewObjectExpression.this.loc, 89);
                emitter.emit(NewObjectExpression.this.loc, ObjectMethods.constructor(type, new TypeInfo[0]));
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
            }

            @Override
            protected Void _default(TypeInfo type) {
                MethodInfo proxy = emitter.getProxyMethodTable().get(NewObjectExpression.this.getLoc(), NewObjectExpression.this.getDefiningType(), type, NewObjectExpression.this.constructor);
                emitter.emitType(NewObjectExpression.this.loc, 187, type);
                if (!NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 89);
                }
                for (Pair pair : EqualPairIterator.iterable(NewObjectExpression.this.parameters, NewObjectExpression.this.constructor.getEmitSignature().getParameterTypes())) {
                    ((Expression)pair.left).emit(emitter);
                    TypeConversion.emit(NewObjectExpression.this.loc, emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
                }
                AsmMethod asmMethod = proxy != null ? proxy.getAsmMethod() : NewObjectExpression.this.constructor.getAsmMethod();
                emitter.emit(NewObjectExpression.this.loc, asmMethod);
                return null;
            }

            @Override
            public Void visit(JavaTypeInfo type) {
                String className = type.getBytecodeName().startsWith("com/salesforce/api/interop/") ? type.getBytecodeName() : "com/salesforce/api/interop/" + type.getBytecodeName();
                emitter.emitType(NewObjectExpression.this.loc, 187, className);
                emitter.emit(NewObjectExpression.this.loc, 89);
                for (Pair pair : EqualPairIterator.iterable(NewObjectExpression.this.parameters, NewObjectExpression.this.constructor.getEmitSignature().getParameterTypes())) {
                    ((Expression)pair.left).emit(emitter);
                }
                emitter.emit(NewObjectExpression.this.loc, NewObjectExpression.this.constructor.getAsmMethodBuilder().setDefiningTypeName(className).build());
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
                return null;
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                emitter.emitType(NewObjectExpression.this.loc, 187, type);
                emitter.emit(NewObjectExpression.this.loc, 89);
                emitter.emit(NewObjectExpression.this.loc, ObjectMethods.constructor(type, new TypeInfo[0]));
                emitter.emit(NewObjectExpression.this.loc, 89);
                emitter.emit(NewObjectExpression.this.loc, SObjectMethods.initializationCompleted(type));
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
                return null;
            }

            @Override
            public Void visit(VfComponentTypeInfo type) {
                this.visitDynamicTypeInfo(type);
                return null;
            }
        });
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public String getMethodName() {
        return PrinterUtil.print(this.typeRef);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public MethodInfo getConstructor() {
        return this.constructor;
    }
}

