/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.MapLiteralKeyValue;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MapEntryNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NewMapLiteralExpression
extends Expression {
    private final Loc loc;
    private final List<TypeRef> types;
    private final List<MapEntryNode> entries;
    private GenericTypeInfo mapType;
    private TypeInfo keyType;
    private TypeInfo valueType;

    public NewMapLiteralExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.MapLiteralCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MapLiteralKeyValue entry : x.pairs.values) {
            builder.add(new MapEntryNode(this, AstNodeFactory.create((AstNode)this, entry.key), AstNodeFactory.create((AstNode)this, entry.value)));
        }
        this.entries = builder.build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (MapEntryNode entry : this.entries) {
                entry.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (this.types.size() != 2) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.map.init"));
            return;
        }
        this.keyType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(0));
        this.valueType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(1));
        if (!CollectionExpressionUtils.validateMap(this.getDefiningType(), this.keyType, this.valueType, scope, this)) {
            return;
        }
        this.mapType = GenericTypeInfoFactory.createMap(this.keyType, this.valueType);
        for (MapEntryNode entry : this.entries) {
            entry.validate(symbols, scope);
            if (!scope.getErrors().isInvalid((AstNode)entry)) continue;
            scope.getErrors().markInvalid(this);
        }
        this.setType(this.mapType);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitType(this.loc, 187, this.mapType);
        emitter.emit(this.loc, 89);
        emitter.emit(this.loc, ObjectMethods.constructor(this.mapType, new TypeInfo[0]));
        for (MapEntryNode entry : this.entries) {
            entry.emit(emitter);
        }
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public TypeInfo getKeyType() {
        assert (this.keyType != null);
        return this.keyType;
    }

    public TypeInfo getValueType() {
        assert (this.valueType != null);
        return this.valueType;
    }
}

