/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.validators.MapPutAllValidator;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import java.util.List;

public class NewMapInitExpression
extends Expression {
    private final Loc loc;
    private final List<TypeRef> types;
    private final Expression init;
    private GenericTypeInfo mapType;

    public NewMapInitExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.MapInitCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.init = x.expr.map(value -> AstNodeFactory.create((AstNode)this, value)).orElse(NOOP);
    }

    private static boolean isInvalidInit(Expression init, TypeInfo type) {
        return init != NOOP && (!CollectionTypeInfoUtil.isMap(init.getType()) || !TypeInfoEquivalence.isEquivalent(init.getType(), type)) && MapPutAllValidator.isInvalidMapInitializationFromList(init.getDefiningType(), type, init.getType());
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.init.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.init.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.init)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.types.size() != 2) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "Map", 2, this.types.size()));
            return;
        }
        TypeInfo keyType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(0));
        TypeInfo valueType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(1));
        if (!CollectionExpressionUtils.validateMap(this.getDefiningType(), keyType, valueType, scope, this)) {
            return;
        }
        this.mapType = GenericTypeInfoFactory.createMap(keyType, valueType);
        if (NewMapInitExpression.isInvalidInit(this.init, this.mapType)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.map.initializer", this.init.getType(), keyType, valueType));
            return;
        }
        this.setType(this.mapType);
    }

    @Override
    public void emit(Emitter emitter) {
        AsmMethod constructor;
        emitter.emitType(this.loc, 187, this.mapType);
        emitter.emit(this.loc, 89);
        this.init.emit(emitter);
        if (this.init == Expression.NOOP) {
            constructor = ObjectMethods.constructor(this.mapType, new TypeInfo[0]);
        } else if (this.init.getType().getBasicType() == BasicType.MAP) {
            constructor = ObjectMethods.constructor(this.mapType, TypeInfos.MAP);
        } else if (CollectionTypeInfoUtil.isList(this.init.getType())) {
            constructor = ObjectMethods.constructor(this.mapType, TypeInfos.LIST);
        } else {
            throw new UnexpectedCodePathException();
        }
        emitter.emit(this.loc, constructor);
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

