/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class NewListInitExpression
extends Expression {
    private final Loc loc;
    private final List<TypeRef> types;
    private final Expression init;
    private TypeInfo type;

    public NewListInitExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.ListInitCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.init = x.expr.map(value -> AstNodeFactory.create((AstNode)this, value)).orElse(NOOP);
    }

    static boolean isValidInit(TypeInfo initType, TypeInfo elementType) {
        return TypeInfoEquivalence.isEquivalent(initType, TypeInfos.INTEGER) || TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createList(elementType)) || TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createSet(elementType));
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.init.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.init.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.init)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.types.size() != 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "List", 1, this.types.size()));
            return;
        }
        TypeInfo elementType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(0));
        if (!CollectionExpressionUtils.validateList(this.getDefiningType(), elementType, scope, this)) {
            return;
        }
        if (this.init != Expression.NOOP && !NewListInitExpression.isValidInit(this.init.getType(), elementType)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.initializer", this.init.getType(), elementType));
            return;
        }
        this.type = GenericTypeInfoFactory.createList(elementType);
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitType(this.loc, 187, this.type);
        emitter.emit(this.loc, 89);
        if (this.init == Expression.NOOP) {
            emitter.emit(this.loc, ObjectMethods.constructor(this.type, new TypeInfo[0]));
        } else if (TypeInfoEquivalence.isEquivalent(this.init.getType(), TypeInfos.INTEGER)) {
            this.init.emit(emitter);
            emitter.emit(this.loc, ObjectMethods.constructor(this.type, TypeInfos.INTEGER));
        } else {
            emitter.emit(this.loc, ObjectMethods.constructor(this.type, new TypeInfo[0]));
            emitter.emit(this.loc, 89);
            this.init.emit(emitter);
            emitter.emit(this.loc, 89);
            Label ifNull = new Label();
            emitter.emitJump(this.loc, 198, ifNull);
            emitter.emit(this.loc, ListMethods.addAll(this.type));
            Label ifNonNull = new Label();
            emitter.emitJump(this.loc, 167, ifNonNull);
            emitter.emit(ifNull);
            emitter.emit(this.loc, 88);
            emitter.emit(ifNonNull);
        }
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

