/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionOptions;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;

public class NestedStoreExpression
extends Expression {
    private final Expression expression;

    public NestedStoreExpression(AstNode definingNode, Expr.NestedExpr expr) {
        super(definingNode);
        this.expression = AstNodeFactory.createStore(definingNode, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        this.expression.traverse(visitor, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
        }
        this.setType(this.expression.getType());
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.expression.getLoc();
    }

    @Override
    public void setOptions(ExpressionOptions options) {
        super.setOptions(options);
        this.expression.setOptions(options);
    }
}

