/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BuiltInMethodMapper;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallInterceptor;
import apex.jorje.semantic.ast.expression.MethodCallInterceptors;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.variable.VariableEmitLoadVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.MethodCallVisibility;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class MethodCallExpression
extends Expression {
    private static final List<MethodCallInterceptor> INTERCEPTORS = ImmutableList.of(new MethodCallInterceptors.AddError(), new MethodCallInterceptors.GetQueryLocator(), new MethodCallInterceptors.IsFuture());
    private final List<Expression> inputParameters;
    private final Identifier name;
    private final ReferenceExpression expression;
    private MethodInfo method;

    public MethodCallExpression(AstNode definingNode, Expr.MethodCallExpr expr) {
        super(definingNode);
        this.expression = new ReferenceExpression(this, ReferenceType.METHOD, expr.dottedExpr, expr.names.subList(0, expr.names.size() - 1));
        this.name = Iterables.getLast(expr.names);
        this.inputParameters = AstNodeFactory.createExpressions(this, expr.inputParameters);
    }

    static TypeInfo convertReturnTypeForFastCall(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(GenericTypeInfoUtil.getRootType(type), WrapperTypeInfos.SYSTEM_LIST_ITERATOR) ? InternalTypeInfos.SYSTEM_ITERATOR : type;
    }

    public Identifier getNameUsed() {
        return this.name;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            if (scope instanceof SymbolScope) {
                SymbolResolver symbols = ((SymbolScope)scope).getSymbols();
                symbols.variables().setAllowLazyDeclaration(this.allowLazyDeclaration());
                this.expression.traverse(visitor, scope);
                symbols.variables().clearAllowLazyDeclaration();
            } else {
                this.expression.traverse(visitor, scope);
            }
            for (Expression actualParameter : this.inputParameters) {
                actualParameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(final SymbolResolver symbols, ValidationScope scope) {
        symbols.variables().setAllowLazyDeclaration(this.allowLazyDeclaration());
        try {
            this.expression.validate(symbols, scope);
        }
        finally {
            symbols.variables().clearAllowLazyDeclaration();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : this.inputParameters) {
            expression.validate(symbols, scope);
            builder.add(expression.getType());
        }
        ImmutableCollection actualParameterTypes = builder.build();
        if (scope.getErrors().isInvalid(this.inputParameters, this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        Signature signature = SignatureFactory.create(this.name.value, (TypeInfo)TypeInfos.VOID, (List<TypeInfo>)((Object)actualParameterTypes));
        Result<MethodInfo> result = symbols.lookupMethodInfo(this.getDefiningType(), this.expression.getContext(), this.expression.getType(), signature);
        if (scope.getErrors().addIfError((AstNode)this, result, I18nSupplier.create("invalid.method.not.found", signature, this.expression.getType()))) {
            return;
        }
        this.method = result.get();
        List<String> visibilityErrors = MethodCallVisibility.calculate(this.getDefiningType(), symbols.getAccessEvaluator(), scope.isTestMethod(), this.method);
        if (!visibilityErrors.isEmpty()) {
            scope.getErrors().markInvalid((AstNode)this, visibilityErrors);
            return;
        }
        scope.getErrors().addIfError((AstNode)this, this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols, this.getDefiningType(), this.method.getName(), this.method.getModifiers(), Member.Type.METHOD));
        for (BuiltInMethodValidator validator : this.method.getValidators()) {
            validator.validate(symbols, scope, this);
        }
        if (scope.getErrors().isInvalid((AstNode)this)) {
            return;
        }
        if (this.method.getModifiers().has(ModifierTypeInfos.ABSTRACT) && ExpressionUtil.isSuperVariableExpression(this.expression.getDottedExpression().getExpression()) && VersionUtil.get(this).isGreaterThan(Version.V172)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.abstract.method.call", this.method, this.expression.getType()));
        }
        if (this.method.getModifiers().has(ModifierTypeInfos.STATIC) && this.expression.getContext() == IdentifierContext.OBJECT) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.static.method.context", this.method, this.expression.getType()));
        }
        if (!this.method.getModifiers().has(ModifierTypeInfos.STATIC) && this.expression.getContext() == IdentifierContext.STATIC) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.non.static.method.context", this.method, this.expression.getType()));
        }
        if (!this.method.getModifiers().has(ModifierTypeInfos.STATIC) && symbols.staticContext().get() && this.expression.getContext() == IdentifierContext.NONE) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.non.static.method.context", this.method, this.expression.getType()));
        }
        TypeInfo returnType = this.method.getReturnType().accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(InternalTypeInfo type) {
                return symbols.lookupTypeInfo(MethodCallExpression.this.getDefiningType(), type);
            }
        });
        this.setType(returnType);
    }

    @Override
    public void emit(Emitter emitter) {
        AsmMethod asmMethod;
        boolean originalSuppressLocation = emitter.getSuppressLocation();
        if (this.method.getName().equalsIgnoreCase("debug") && TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SYSTEM, this.method.getDefiningType())) {
            emitter.setSuppressLocation(true);
        }
        for (MethodCallInterceptor interceptor : INTERCEPTORS) {
            if (!interceptor.shouldIntercept(this)) continue;
            interceptor.intercept(this, emitter);
            return;
        }
        this.emitReferenceExpression(emitter);
        MethodInfo proxy = emitter.getProxyMethodTable().get(this.getLoc(), this.getDefiningType(), this.expression.getType(), this.method);
        if (this.expression.getContext() == IdentifierContext.NONE && !this.method.getModifiers().has(ModifierTypeInfos.STATIC)) {
            emitter.emitVar(this.name.loc, 25, 0);
        }
        this.emitParameters(emitter);
        if (proxy != null) {
            emitter.emit(this.name.loc, proxy.getAsmMethod());
            this.convertReturnTypeIfNecessary(emitter);
        } else if (TypeInfoUtil.isFastCallType(this.expression.getType())) {
            emitter.emit(this.name.loc, this.method.getAsmMethodBuilder().setDefiningTypeAsBytecodeMethodName(GenericTypeInfoUtil.getRootType(this.method.getDefiningType())).build());
            if (!this.isTopLevel() && this.method.hasReturnValue() && !TypeInfoEquivalence.isEquivalent(this.method.getReturnType(), TypeInfos.OBJECT) && !this.method.isDuckTyped()) {
                emitter.push(Loc._SyntheticLoc(), MethodCallExpression.convertReturnTypeForFastCall(this.method.getReturnType()).getBytecodeName());
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.convert());
            }
        } else if (ExpressionUtil.isSuperVariableExpression(this.expression.getDottedExpression().getExpression())) {
            if (this.method.getModifiers().has(ModifierTypeInfos.ABSTRACT)) {
                emitter.emit(this.name.loc, 87);
                for (int i = 0; i < this.getInputParameters().size(); ++i) {
                    emitter.emit(this.name.loc, 87);
                }
                if (!this.isTopLevel() && this.method.hasReturnValue()) {
                    emitter.emit(this.name.loc, 1);
                }
                return;
            }
            emitter.emit(this.name.loc, this.method.getAsmMethodBuilder().invokeSpecial().build());
        } else if (this.expression.getType().getBasicType() == BasicType.OBJECT) {
            if (this.method.getName().equalsIgnoreCase("equals")) {
                emitter.emit(this.name.loc, SystemMethods.equalsMethod());
            } else if (this.method.getName().equalsIgnoreCase("hashCode")) {
                emitter.emit(this.name.loc, SystemMethods.hashCodeMethod());
            } else {
                emitter.emit(this.name.loc, this.method.getAsmMethod());
            }
        } else if (this.expression.getType().getBasicType().isApexObject()) {
            this.method.getProfilingType().emit(emitter, this);
            asmMethod = !this.method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.method.getAsmMethodBuilder().setDefiningTypeAsBytecodeMethodName(this.expression.getType()).build() : this.method.getAsmMethod();
            emitter.emit(this.name.loc, asmMethod);
            this.convertReturnTypeIfNecessary(emitter);
        } else if (this.expression.getType().getBasicType() == BasicType.JAVA) {
            emitter.emit(this.name.loc, this.method.getAsmMethod());
        } else if (this.expression.getType().getBasicType() == BasicType.SOBJECT) {
            asmMethod = SObjectMethods.mapToStatic(this.method);
            emitter.emit(this.name.loc, asmMethod);
            TypeConversion.emitOrCheckCast(this.name.loc, emitter, asmMethod.signature.getReturnType(), this.method.getReturnType());
        } else {
            this.method.getProfilingType().emit(emitter, this);
            new BuiltInMethodMapper().emit(this.name.loc, emitter, this.method);
        }
        this.finishCall(emitter);
        emitter.setSuppressLocation(originalSuppressLocation);
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    public String getMethodName() {
        return this.name.value;
    }

    private void convertReturnTypeIfNecessary(Emitter emitter) {
        if (this.method.needsReturnTypeConversion()) {
            TypeConversion.emit(this.name.loc, emitter, TypeInfos.OBJECT, this.method.getReturnType());
        }
    }

    public void finishCall(Emitter emitter) {
        if (this.isTopLevel() && this.method.hasReturnValue()) {
            emitter.emit(this.name.loc, 87);
        }
        if (!this.isTopLevel() && !this.method.hasReturnValue()) {
            emitter.emit(this.name.loc, 1);
        }
    }

    private void emitParameters(Emitter emitter) {
        for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(this.inputParameters, this.method.getEmitSignature().getParameterTypes())) {
            ((Expression)pair.left).emit(emitter);
            TypeConversion.emit(this.name.loc, emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
        }
    }

    private boolean allowLazyDeclaration() {
        return Version.V174.isGreaterThanOrEqual(VersionUtil.get(this));
    }

    public MethodInfo getMethod() {
        assert (this.method != null);
        return this.method;
    }

    public List<Expression> getInputParameters() {
        return this.inputParameters;
    }

    public void emitReferenceExpression(Emitter emitter) {
        boolean shouldReset = false;
        try {
            shouldReset = emitter.setVariableVisitor(new VariableEmitLoadVisitor(this, emitter));
            this.expression.emit(emitter);
        }
        finally {
            if (shouldReset) {
                emitter.setVariableVisitor(null);
            }
        }
    }

    public ReferenceExpression getReferenceExpression() {
        return this.expression;
    }
}

