/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Literal;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.StringConcatenation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.Location;

public class LiteralExpression
extends Expression {
    private final Literal literal;
    private final Loc loc;

    public LiteralExpression(AstNode definingNode, Expr.LiteralExpr expr) {
        super(definingNode);
        this.literal = expr.literal;
        this.loc = Location.from(this.literal);
        if (expr.literal != null) {
            expr.literal._switch(new Literal.SwitchBlockWithDefault(){

                @Override
                public void _case(Literal.NullLiteral x) {
                }

                @Override
                protected void _default(Literal x) {
                    LiteralExpression.this.setNotNullable();
                }
            });
        }
    }

    public static Object getLiteral(Literal literal) {
        return literal == null ? null : literal.match(new Literal.MatchBlock<Object>(){

            @Override
            public Object _case(Literal.StringLiteral x) {
                return x.literal;
            }

            @Override
            public Object _case(Literal.IntegerLiteral x) {
                return x.literal;
            }

            @Override
            public Object _case(Literal.LongLiteral x) {
                return x.literal;
            }

            @Override
            public Object _case(Literal.DoubleLiteral x) {
                return x.literal;
            }

            @Override
            public Object _case(Literal.DecimalLiteral x) {
                return x.literal;
            }

            @Override
            public Object _case(Literal.NullLiteral x) {
                return null;
            }

            @Override
            public Object _case(Literal.TrueLiteral x) {
                return true;
            }

            @Override
            public Object _case(Literal.FalseLiteral x) {
                return false;
            }
        });
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (this.literal == null) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo type = this.literal.match(new Literal.MatchBlock<TypeInfo>(){

            @Override
            public TypeInfo _case(Literal.StringLiteral x) {
                return TypeInfos.STRING;
            }

            @Override
            public TypeInfo _case(Literal.IntegerLiteral x) {
                return TypeInfos.INTEGER;
            }

            @Override
            public TypeInfo _case(Literal.LongLiteral x) {
                return TypeInfos.LONG;
            }

            @Override
            public TypeInfo _case(Literal.DoubleLiteral x) {
                return TypeInfos.DOUBLE;
            }

            @Override
            public TypeInfo _case(Literal.DecimalLiteral x) {
                return TypeInfos.DECIMAL;
            }

            @Override
            public TypeInfo _case(Literal.NullLiteral x) {
                return InternalTypeInfos.NULL;
            }

            @Override
            public TypeInfo _case(Literal.TrueLiteral x) {
                return TypeInfos.BOOLEAN;
            }

            @Override
            public TypeInfo _case(Literal.FalseLiteral x) {
                return TypeInfos.BOOLEAN;
            }
        });
        this.setType(type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.literal._switch(new Literal.SwitchBlock(){

            @Override
            public void _case(Literal.StringLiteral x) {
                StringConcatenation.emitLiteral(LiteralExpression.this, emitter, x.literal);
            }

            @Override
            public void _case(Literal.IntegerLiteral x) {
                emitter.push(x.loc, x.literal);
                emitter.box(LiteralExpression.this.getType());
            }

            @Override
            public void _case(Literal.LongLiteral x) {
                emitter.push(x.loc, x.literal);
                emitter.box(LiteralExpression.this.getType());
            }

            @Override
            public void _case(Literal.DoubleLiteral x) {
                emitter.push(x.loc, x.literal);
                emitter.box(LiteralExpression.this.getType());
            }

            @Override
            public void _case(Literal.DecimalLiteral x) {
                emitter.push(x.loc, x.literal.toString());
                emitter.emit(x.loc, DecimalMethods.valueOfBytecode());
            }

            @Override
            public void _case(Literal.NullLiteral x) {
                emitter.emit(x.loc, 1);
            }

            @Override
            public void _case(Literal.TrueLiteral x) {
                emitter.push(x.loc, true);
                emitter.box(LiteralExpression.this.getType());
            }

            @Override
            public void _case(Literal.FalseLiteral x) {
                emitter.push(x.loc, false);
                emitter.box(LiteralExpression.this.getType());
            }
        });
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public Literal getLiteralExpr() {
        return this.literal;
    }

    public Object getLiteral() {
        return LiteralExpression.getLiteral(this.literal);
    }
}

