/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class JavaMethodCallExpression
extends Expression {
    private final Loc loc;
    private final List<Identifier> names;
    private final PrintContext ctx;
    private final List<Expression> parameters;
    private MethodInfo method;

    public JavaMethodCallExpression(AstNode definingNode, Expr.JavaMethodCallExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
        this.names = expr.names;
        this.ctx = new PrintContext();
        this.parameters = AstNodeFactory.createExpressions(this, expr.inputParameters);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression parameter : this.parameters) {
                parameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!this.getDefiningType().getCodeUnitDetails().isTrusted()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.java.expression"));
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : this.parameters) {
            expression.validate(symbols, scope);
            builder.add(expression.getType());
        }
        ImmutableCollection parameters = builder.build();
        if (scope.getErrors().isInvalid(this.parameters)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.names.size() <= 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression"));
            return;
        }
        String className = PrinterUtil.get().getFactory().dottedIdentifier().print(this.names.subList(0, this.names.size() - 1), this.ctx);
        String methodName = PrinterUtil.get().getFactory().identifierPrinter().print(this.names.get(this.names.size() - 1), this.ctx);
        Class clazz = JavaTypeInfoUtil.get().lookupClass(className);
        if (clazz == null) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression.class.not.found", className));
            return;
        }
        TypeInfo definingType = JavaTypeInfoUtil.get().createJava((Class<?>)clazz);
        Signature signature = SignatureFactory.create(methodName, (TypeInfo)TypeInfos.VOID, (List<TypeInfo>)((Object)parameters));
        Result<MethodInfo> result = symbols.lookupMethodInfo(this.getDefiningType(), IdentifierContext.STATIC, definingType, signature);
        if (scope.getErrors().addIfError((AstNode)this, result, I18nSupplier.create("invalid.java.expression.method.not.found", signature, className))) {
            return;
        }
        this.method = result.get();
        if (!this.method.getModifiers().has(ModifierTypeInfos.STATIC)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression.method.not.static", methodName, className));
            return;
        }
        this.setType(this.method.getReturnType());
    }

    @Override
    public void emit(Emitter emitter) {
        int i = 0;
        for (Expression expression : this.parameters) {
            expression.emit(emitter);
            TypeConversion.emit(this.loc, emitter, expression.getType(), this.method.getParameterTypes().get(i++));
        }
        emitter.emit(this.loc, this.method.getAsmMethod());
        if (this.isTopLevel() && this.method.hasReturnValue()) {
            emitter.emit(this.loc, 87);
        }
        if (!this.isTopLevel() && !this.method.hasReturnValue()) {
            emitter.emit(this.loc, 1);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

