/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

public class InstanceOfExpression
extends Expression {
    private final TypeRef typeRef;
    private final Expression expression;
    private final Loc loc;
    private TypeInfo type;

    public InstanceOfExpression(AstNode definingNode, Expr.InstanceOf expr) {
        super(definingNode);
        this.typeRef = expr.type;
        this.loc = expr.loc;
        this.expression = AstNodeFactory.create((AstNode)this, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        boolean isAssignable;
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, scope.isTestMethod())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        boolean bl = isAssignable = Distance.get().canAssign(this.getDefiningType(), this.expression.getType(), this.type) && SObjectTypeInfoUtil.isSObjectList(this.expression.getType()) == SObjectTypeInfoUtil.isSObjectList(this.type);
        if (!(!isAssignable || TypeInfoEquivalence.isEquivalent(this.expression.getType(), TypeInfos.STRING) && this.type.equals(TypeInfos.ID) || SObjectTypeInfoUtil.isSObjectList(this.expression.getType()) && SObjectTypeInfoUtil.isSObjectList(this.type) && Distance.get().canAssign(this.getDefiningType(), CollectionTypeInfoUtil.getElementType(this.type), CollectionTypeInfoUtil.getElementType(this.expression.getType())))) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.always.true", this.expression.getType(), this.type));
            return;
        }
        if (!this.expression.getType().getBasicType().canBeCastOrInstanceOf()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.invalid.type", this.expression.getType()));
        } else if (!isAssignable && !Distance.get().canAssign(this.getDefiningType(), this.type, this.expression.getType()) && this.expression.getType().getUnitType() != UnitType.INTERFACE && this.type.getUnitType() != UnitType.INTERFACE) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.always.false", this.expression.getType(), this.type));
            return;
        }
        this.setType(TypeInfos.BOOLEAN);
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
        if (TypeInfoEquivalence.isEquivalent(this.expression.getType(), TypeInfos.STRING) && this.type.equals(TypeInfos.ID)) {
            emitter.emit(this.loc, SystemMethods.stringInstanceOfId());
        } else {
            emitter.push(this.loc, this.type.getBytecodeName());
            emitter.emit(this.loc, SystemMethods.instanceOf());
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

