/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.DottedExpr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import java.util.Optional;

public class DottedExpression
extends Expression {
    private final Expression expression;

    public DottedExpression(AstNode definingNode, Optional<DottedExpr> dottedExpr) {
        super(definingNode);
        this.expression = dottedExpr.map(value -> AstNodeFactory.create((AstNode)this, value.expr)).orElse(NOOP);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(this.expression == NOOP ? this.getDefiningType() : this.expression.getType());
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.expression.getLoc();
    }

    public boolean isNoop() {
        return this.expression == NOOP;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

