/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.IdMethods;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import shaded.org.objectweb.asm.Label;

public interface Comparison {
    public void emitUnbox(Emitter var1, TypeInfo var2);

    public void emitComparison(Loc var1, Emitter var2, Label var3);

    public static final class ReferenceComparison
    implements Comparison {
        private final int opcode;

        public ReferenceComparison(int opcode) {
            this.opcode = opcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Loc loc, Emitter emitter, Label falseLabel) {
            emitter.emitJump(loc, this.opcode, falseLabel);
        }
    }

    public static final class IdComparison
    implements Comparison {
        private final BooleanOp op;
        private final int unaryOpcode;

        public IdComparison(BooleanOp op, int unaryOpcode) {
            this.op = op;
            this.unaryOpcode = unaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Loc loc, Emitter emitter, Label falseLabel) {
            boolean value = this.op.match(new BooleanOp.MatchBlockWithDefault<Boolean>(){

                @Override
                public Boolean _case(BooleanOp.DoubleEqual x) {
                    return false;
                }

                @Override
                public Boolean _case(BooleanOp.NotEqual x) {
                    return false;
                }

                @Override
                public Boolean _case(BooleanOp.AltNotEqual x) {
                    return false;
                }

                @Override
                protected Boolean _default(BooleanOp x) {
                    return true;
                }
            });
            emitter.push(loc, value);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(loc, IdMethods.compareTo());
            emitter.unbox(TypeInfos.INTEGER);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class StaticComparison
    implements Comparison {
        private final int unaryOpcode;
        private final AsmMethod method;

        public StaticComparison(int unaryOpcode, AsmMethod method) {
            this.unaryOpcode = unaryOpcode;
            this.method = method;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Loc loc, Emitter emitter, Label falseLabel) {
            emitter.emit(loc, this.method);
            emitter.unbox(TypeInfos.INTEGER);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class BinaryComparison
    implements Comparison {
        private final int unaryOpcode;
        private final int binaryOpcode;

        public BinaryComparison(int unaryOpcode, int binaryOpcode) {
            this.unaryOpcode = unaryOpcode;
            this.binaryOpcode = binaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
            emitter.unbox(type);
        }

        @Override
        public void emitComparison(Loc loc, Emitter emitter, Label falseLabel) {
            emitter.emit(loc, this.binaryOpcode);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class UnaryComparison
    implements Comparison {
        private final int unaryOpcode;

        public UnaryComparison(int unaryOpcode) {
            this.unaryOpcode = unaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
            emitter.unbox(type);
        }

        @Override
        public void emitComparison(Loc loc, Emitter emitter, Label falseLabel) {
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }
}

