/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.expression.BuiltInMethodMapper;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BuiltInMethodMapperTest {
    private static final MethodInfo STATIC_FOO = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("foo").setNamedParameterTypes(InternalTypeInfos.SOBJECT_USER, TypeInfos.INTEGER).setReturnType(TypeInfos.INTEGER).setModifiers(ModifierGroups.GLOBAL_STATIC).setGenerated(Generated.USER).build();
    private static final MethodInfo NON_STATIC_FOO = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("foo").setReturnType(TypeInfos.INTEGER).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
    private static final MethodInfo NON_STATIC_STRING = StandardMethodInfo.builder().setDefiningType(TypeInfos.STRING).setName("foo").setReturnType(TypeInfos.INTEGER).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
    private static final MethodInfo INTEGER_GET_SOBJECT_TYPE = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName("getSObjectType").setReturnType(TypeInfos.SOBJECT).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
    private static final MethodInfo ID_GET_SOBJECT_TYPE = StandardMethodInfo.builder().setDefiningType(TypeInfos.ID).setName("getSObjectType").setReturnType(TypeInfos.SOBJECT).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
    private static final MethodInfo ID_FOO = StandardMethodInfo.builder().setDefiningType(TypeInfos.ID).setName("foo").setReturnType(TypeInfos.SOBJECT).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
    private static final BuiltInMethodMapper mapper = new BuiltInMethodMapper();

    @DataProvider
    Object[][] convertInvocation() {
        return new Object[][]{{STATIC_FOO, 184}, {NON_STATIC_FOO, 182}, {NON_STATIC_STRING, 184}};
    }

    @Test(dataProvider="convertInvocation")
    public void testConvertInvocation(MethodInfo method, int opcode) {
        MatcherAssert.assertThat((Object)mapper.convertInvocation(method), (Matcher)Is.is((Object)opcode));
    }

    @DataProvider
    Object[][] convertSignatureForEmit() {
        return new Object[][]{{STATIC_FOO, SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.SOBJECT, TypeInfos.INTEGER)}, {NON_STATIC_FOO, SignatureFactory.create("foo", TypeInfos.INTEGER)}, {NON_STATIC_STRING, SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.STRING)}};
    }

    @Test(dataProvider="convertSignatureForEmit")
    public void testConvertSignatureForEmit(MethodInfo method, Signature signature) {
        MatcherAssert.assertThat((Object)mapper.convertSignatureForEmit(method), (Matcher)Is.is((Object)signature));
    }

    @DataProvider
    Object[][] mapToGenericSObject() {
        return new Object[][]{{TypeInfos.SOBJECT, TypeInfos.SOBJECT}, {InternalTypeInfos.SOBJECT_USER, TypeInfos.SOBJECT}, {TypeInfos.INTEGER, TypeInfos.INTEGER}};
    }

    @Test(dataProvider="mapToGenericSObject")
    public void testMapToGenericSObject(TypeInfo type, TypeInfo expected) {
        MatcherAssert.assertThat((Object)mapper.mapToGenericSObject(type), IsType.isType(expected));
    }

    @DataProvider
    Object[][] idGetSObjectTypeReturnsJavaObject() {
        return new Object[][]{{ID_GET_SOBJECT_TYPE, true}, {ID_FOO, false}, {INTEGER_GET_SOBJECT_TYPE, false}};
    }

    @Test(dataProvider="idGetSObjectTypeReturnsJavaObject")
    public void testIdGetSObjectTypeReturnsJavaObject(MethodInfo method, boolean expected) {
        MatcherAssert.assertThat((Object)mapper.isUseValueTypeMethod(method), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testMethodWithDifferentEmitSignature() {
        Signature emitSignature = SignatureFactory.create("bar", (TypeInfo)TypeInfos.LONG, TypeInfos.INTEGER);
        MethodInfo method = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("foo").setNamedParameterTypes(TypeInfos.STRING).setReturnType(TypeInfos.BOOLEAN).setEmitSignature(emitSignature).setModifiers(ModifierGroups.GLOBAL_VIRTUAL).setGenerated(Generated.USER).build();
        MatcherAssert.assertThat((Object)mapper.convertSignatureForEmit(method), (Matcher)Is.is((Object)emitSignature));
    }
}

