/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;

public enum BooleanExpressionType {
    AND,
    OR,
    COMPARISON;


    public static BooleanExpressionType get(BooleanOp op) {
        return op.match(new BooleanOp.MatchBlockWithDefault<BooleanExpressionType>(){

            @Override
            public BooleanExpressionType _case(BooleanOp.And x) {
                return AND;
            }

            @Override
            public BooleanExpressionType _case(BooleanOp.Or x) {
                return OR;
            }

            @Override
            protected BooleanExpressionType _default(BooleanOp x) {
                return COMPARISON;
            }
        });
    }

    public boolean isSameType(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(BooleanExpression node, ValueScope<Boolean> scope) {
                scope.setValue(node.getBooleanExpressionType() == BooleanExpressionType.this);
            }
        }, false);
    }
}

