/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.BinaryOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.StringConcatenation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DateMethods;
import apex.jorje.semantic.bcl.DateTimeMethods;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.TimeMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.ast.BinaryOpPrinter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class BinaryExpression
extends Expression {
    private final Loc loc;
    private final Expression left;
    private final BinaryOp op;
    private final Expression right;

    public BinaryExpression(AstNode definingNode, Expr.BinaryExpr expr) {
        super(definingNode);
        this.loc = Location.from(expr);
        this.left = AstNodeFactory.create((AstNode)this, expr.left);
        this.op = expr.op;
        this.right = AstNodeFactory.create((AstNode)this, expr.right);
    }

    public BinaryExpression(AstNode definingNode, Loc loc, Expression left, BinaryOp op, Expression right) {
        super(definingNode);
        this.loc = loc;
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, final ValidationScope scope) {
        this.left.validate(symbols, scope);
        this.right.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.left, this.right)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo type = this.op.match(new BinaryOp.MatchBlock<TypeInfo>(){

            @Override
            public TypeInfo _case(BinaryOp.Addition x) {
                return BinaryExpression.this.calculateArithmeticType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.Subtraction x) {
                return BinaryExpression.this.calculateArithmeticType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.Multiplication x) {
                return BinaryExpression.this.calculateArithmeticType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.Division x) {
                return BinaryExpression.this.calculateArithmeticType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.LeftShift x) {
                return BinaryExpression.this.calculateShiftType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.SignedRightShift x) {
                return BinaryExpression.this.calculateShiftType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.UnsignedRightShift x) {
                return BinaryExpression.this.calculateShiftType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.BitwiseXor x) {
                return BinaryExpression.this.calculateBitwiseType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.BitwiseAnd x) {
                return BinaryExpression.this.calculateBitwiseType(scope);
            }

            @Override
            public TypeInfo _case(BinaryOp.BitwiseOr x) {
                return BinaryExpression.this.calculateBitwiseType(scope);
            }
        });
        this.setType(type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.op._switch(new BinaryOp.SwitchBlock(){

            @Override
            public void _case(BinaryOp.Addition x) {
                BinaryExpression.this.addition(emitter);
            }

            @Override
            public void _case(BinaryOp.Subtraction x) {
                BinaryExpression.this.subtraction(emitter);
            }

            @Override
            public void _case(BinaryOp.Multiplication x) {
                BinaryExpression.this.multiplication(emitter);
            }

            @Override
            public void _case(BinaryOp.Division x) {
                BinaryExpression.this.division(emitter);
            }

            @Override
            public void _case(BinaryOp.LeftShift x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: {
                        BinaryExpression.this.shift(emitter, 120);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.shift(emitter, 121);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(BinaryOp.SignedRightShift x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: {
                        BinaryExpression.this.shift(emitter, 122);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.shift(emitter, 123);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(BinaryOp.UnsignedRightShift x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: {
                        BinaryExpression.this.shift(emitter, 124);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.shift(emitter, 125);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(BinaryOp.BitwiseXor x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: 
                    case BOOLEAN: {
                        BinaryExpression.this.emitArithmetic(emitter, 130);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.emitArithmetic(emitter, 131);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(BinaryOp.BitwiseAnd x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: 
                    case BOOLEAN: {
                        BinaryExpression.this.emitArithmetic(emitter, 126);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.emitArithmetic(emitter, 127);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(BinaryOp.BitwiseOr x) {
                switch (BinaryExpression.this.getType().getBasicType()) {
                    case INTEGER: 
                    case BOOLEAN: {
                        BinaryExpression.this.emitArithmetic(emitter, 128);
                        break;
                    }
                    case LONG: {
                        BinaryExpression.this.emitArithmetic(emitter, 129);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }
        });
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    private void addition(Emitter emitter) {
        switch (this.getType().getBasicType()) {
            case STRING: {
                new StringConcatenation(this, emitter).emit(this.foldStringExpressions());
                break;
            }
            case TIME: 
            case DATE: 
            case DATE_TIME: {
                this.addTime(emitter, false);
                break;
            }
            case DECIMAL: {
                this.emitDecimalArithmetic(emitter, DecimalMethods.add());
                break;
            }
            case DOUBLE: {
                if (VersionUtil.get(emitter).isBetween(Version.V158, Version.V168)) {
                    this.emit158To168DoubleArithmetic(emitter, DecimalMethods.add());
                    break;
                }
                this.emitArithmetic(emitter, 99);
                break;
            }
            case LONG: {
                this.emitArithmetic(emitter, 97);
                break;
            }
            case INTEGER: {
                this.emitArithmetic(emitter, 96);
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
    }

    private void addTime(Emitter emitter, boolean negate) {
        this.left.emit(emitter);
        this.right.emit(emitter);
        switch (this.getType().getBasicType()) {
            case TIME: {
                TypeConversion.emit(this.loc, emitter, this.right.getType(), TypeInfos.INTEGER);
                if (negate) {
                    emitter.unbox(TypeInfos.INTEGER);
                    emitter.emit(this.loc, 116);
                    emitter.box(TypeInfos.INTEGER);
                }
                emitter.emit(this.loc, TimeMethods.addMilliseconds());
                break;
            }
            case DATE: {
                TypeConversion.emit(this.loc, emitter, this.right.getType(), TypeInfos.INTEGER);
                if (negate) {
                    emitter.unbox(TypeInfos.INTEGER);
                    emitter.emit(this.loc, 116);
                    emitter.box(TypeInfos.INTEGER);
                }
                emitter.emit(this.loc, DateMethods.addDays());
                break;
            }
            case DATE_TIME: {
                TypeConversion.emit(this.loc, emitter, this.right.getType(), TypeInfos.DOUBLE);
                if (negate) {
                    emitter.unbox(TypeInfos.DOUBLE);
                    emitter.emit(this.loc, 119);
                    emitter.box(TypeInfos.DOUBLE);
                }
                emitter.emit(this.loc, DateTimeMethods.addDays());
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
    }

    private void subtraction(Emitter emitter) {
        switch (this.getType().getBasicType()) {
            case TIME: 
            case DATE: 
            case DATE_TIME: {
                this.addTime(emitter, true);
                break;
            }
            case DECIMAL: {
                this.emitDecimalArithmetic(emitter, DecimalMethods.subtract());
                break;
            }
            case DOUBLE: {
                if (VersionUtil.get(emitter).isBetween(Version.V158, Version.V168)) {
                    this.emit158To168DoubleArithmetic(emitter, DecimalMethods.subtract());
                    break;
                }
                this.emitArithmetic(emitter, 103);
                break;
            }
            case LONG: {
                this.emitArithmetic(emitter, 101);
                break;
            }
            case INTEGER: {
                this.emitArithmetic(emitter, 100);
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
    }

    private void multiplication(Emitter emitter) {
        switch (this.getType().getBasicType()) {
            case DECIMAL: {
                this.emitDecimalArithmetic(emitter, DecimalMethods.multiply());
                break;
            }
            case DOUBLE: {
                if (VersionUtil.get(emitter).isBetween(Version.V158, Version.V166)) {
                    this.emit158To168DoubleArithmetic(emitter, DecimalMethods.multiply());
                    break;
                }
                this.emitArithmetic(emitter, 107);
                break;
            }
            case LONG: {
                this.emitArithmetic(emitter, 105);
                break;
            }
            case INTEGER: {
                this.emitArithmetic(emitter, 104);
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
    }

    private void division(Emitter emitter) {
        switch (this.getType().getBasicType()) {
            case DECIMAL: {
                this.emitDecimalArithmetic(emitter, DecimalMethods.divide());
                break;
            }
            case DOUBLE: {
                this.unboxBothSides(emitter);
                emitter.emit(this.loc, 92);
                emitter.emit(this.loc, 14);
                emitter.emit(this.loc, 151);
                this.emitThrowDivideByZeroException(emitter, 111);
                break;
            }
            case LONG: {
                this.unboxBothSides(emitter);
                emitter.emit(this.loc, 92);
                emitter.emit(this.loc, 9);
                emitter.emit(this.loc, 148);
                this.emitThrowDivideByZeroException(emitter, 109);
                break;
            }
            case INTEGER: {
                this.unboxBothSides(emitter);
                emitter.emit(this.loc, 89);
                this.emitThrowDivideByZeroException(emitter, 108);
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
    }

    private void unboxBothSides(Emitter emitter) {
        this.left.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.left.getType(), this.getType());
        emitter.unbox(this.getType());
        this.right.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.right.getType(), this.getType());
        emitter.unbox(this.getType());
    }

    private void emitThrowDivideByZeroException(Emitter emitter, int operation) {
        Label branch = new Label();
        emitter.emitJump(this.loc, 154, branch);
        emitter.emit(this.loc, SystemMethods.throwDivideByZeroException());
        emitter.emit(branch);
        emitter.emit(this.loc, operation);
        emitter.box(this.getType());
    }

    private void shift(Emitter emitter, int operation) {
        this.left.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.left.getType(), this.getType());
        emitter.unbox(this.getType());
        this.right.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.right.getType(), TypeInfos.INTEGER);
        emitter.unbox(TypeInfos.INTEGER);
        emitter.emit(this.loc, operation);
        emitter.box(this.getType());
    }

    private void emitDecimalArithmetic(Emitter emitter, AsmMethod operation) {
        this.left.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.left.getType(), this.getType());
        this.right.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.right.getType(), this.getType());
        emitter.emit(this.loc, operation);
    }

    private void emit158To168DoubleArithmetic(Emitter emitter, AsmMethod operation) {
        this.left.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.left.getType(), this.getType());
        emitter.emit(this.loc, DecimalMethods.valueOfDouble());
        this.right.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.right.getType(), this.getType());
        emitter.emit(this.loc, DecimalMethods.valueOfDouble());
        emitter.emit(this.loc, operation);
        emitter.emit(this.loc, DecimalMethods.doubleValue());
    }

    private void emitArithmetic(Emitter emitter, int operation) {
        this.unboxBothSides(emitter);
        emitter.emit(this.loc, operation);
        emitter.box(this.getType());
    }

    private TypeInfo calculateArithmeticType(final ValidationScope scope) {
        TypeInfo leftType = this.left.getType();
        TypeInfo rightType = this.right.getType();
        if ((leftType.equals(TypeInfos.VOID) || rightType.equals(TypeInfos.VOID)) && Version.V174.isLessThanOrEqual(VersionUtil.get(this))) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.void.arithmetic.expression"));
            return UnresolvedTypeInfoFactory.get();
        }
        if (leftType.equals(TypeInfos.STRING) || rightType.equals(TypeInfos.STRING)) {
            return this.op.match(new BinaryOp.MatchBlockWithDefault<TypeInfo>(){

                @Override
                public TypeInfo _case(BinaryOp.Addition x) {
                    return TypeInfos.STRING;
                }

                @Override
                protected TypeInfo _default(BinaryOp x) {
                    scope.getErrors().markInvalid((AstNode)BinaryExpression.this, I18nSupport.getLabel("invalid.numeric.arguments.expression"));
                    return UnresolvedTypeInfoFactory.get();
                }
            });
        }
        if (leftType.equals(TypeInfos.DATE) || leftType.equals(TypeInfos.DATE_TIME) || leftType.equals(TypeInfos.TIME)) {
            this.op._switch(new BinaryOp.SwitchBlockWithDefault(){

                @Override
                public void _case(BinaryOp.Addition x) {
                }

                @Override
                public void _case(BinaryOp.Subtraction x) {
                }

                @Override
                protected void _default(BinaryOp x) {
                    scope.getErrors().markInvalid((AstNode)BinaryExpression.this, I18nSupport.getLabel("invalid.numeric.arguments.expression"));
                }
            });
            switch (leftType.getBasicType()) {
                case TIME: {
                    if (!this.right.getType().equals(TypeInfos.INTEGER) && !this.right.getType().equals(TypeInfos.LONG)) {
                        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.time.operand.expression"));
                    }
                    return TypeInfos.TIME;
                }
                case DATE: {
                    if (!this.right.getType().equals(TypeInfos.INTEGER) && !this.right.getType().equals(TypeInfos.LONG)) {
                        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.date.operand.expression"));
                    }
                    return TypeInfos.DATE;
                }
                case DATE_TIME: {
                    if (!(this.right.getType().equals(TypeInfos.INTEGER) || this.right.getType().equals(TypeInfos.DOUBLE) || this.right.getType().equals(TypeInfos.DECIMAL))) {
                        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.datetime.operand.expression"));
                    }
                    return TypeInfos.DATE_TIME;
                }
            }
            throw new UnexpectedCodePathException();
        }
        if (!leftType.getBasicType().isNumber() || !rightType.getBasicType().isNumber()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.numeric.arguments.expression"));
            return UnresolvedTypeInfoFactory.get();
        }
        if (leftType.equals(TypeInfos.DECIMAL) || rightType.equals(TypeInfos.DECIMAL)) {
            return TypeInfos.DECIMAL;
        }
        if (leftType.equals(TypeInfos.DOUBLE) || rightType.equals(TypeInfos.DOUBLE)) {
            return TypeInfos.DOUBLE;
        }
        if (leftType.equals(TypeInfos.LONG) || rightType.equals(TypeInfos.LONG)) {
            return TypeInfos.LONG;
        }
        return TypeInfos.INTEGER;
    }

    private TypeInfo calculateShiftType(ValidationScope scope) {
        TypeInfo leftType = this.left.getType();
        TypeInfo rightType = this.right.getType();
        if (!leftType.getBasicType().isIntegerOrLong() || !rightType.getBasicType().isIntegerOrLong()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.shift.operator.arguments", new BinaryOpPrinter().print(this.op, new PrintContext())));
            return UnresolvedTypeInfoFactory.get();
        }
        if (Version.V160.isGreaterThan(VersionUtil.get(this)) && leftType.getBasicType() == BasicType.INTEGER && rightType.getBasicType() == BasicType.LONG) {
            return TypeInfos.LONG;
        }
        return leftType;
    }

    private TypeInfo calculateBitwiseType(ValidationScope scope) {
        TypeInfo leftType = this.left.getType();
        TypeInfo rightType = this.right.getType();
        if (leftType.equals(TypeInfos.BOOLEAN) && rightType.equals(TypeInfos.BOOLEAN)) {
            return TypeInfos.BOOLEAN;
        }
        if (leftType.equals(TypeInfos.INTEGER) && rightType.equals(TypeInfos.INTEGER)) {
            return TypeInfos.INTEGER;
        }
        if (leftType.getBasicType().isIntegerOrLong() && rightType.getBasicType().isIntegerOrLong()) {
            return TypeInfos.LONG;
        }
        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.bitwise.operator.arguments", new BinaryOpPrinter().print(this.op, new PrintContext())));
        return UnresolvedTypeInfoFactory.get();
    }

    private List<Expression> foldStringExpressions() {
        BinaryExpression current;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!this.isStringAppend(this.left)) {
            builder.add(this.left);
            builder.add(this.right);
            return builder.build();
        }
        ArrayDeque<Expression> expressions = Queues.newArrayDeque();
        expressions.push(this.left);
        while (this.isStringAppend((Expression)expressions.peek())) {
            current = ExpressionUtil.getBinaryExpression((Expression)expressions.peek());
            expressions.push(current.left);
        }
        builder.add(expressions.pop());
        while (!expressions.isEmpty()) {
            current = ExpressionUtil.getBinaryExpression((Expression)expressions.pop());
            builder.add(current.right);
        }
        builder.add(this.right);
        return builder.build();
    }

    private boolean isStringAppend(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(BinaryExpression node, ValueScope<Boolean> scope) {
                scope.setValue(node.getType().equals(TypeInfos.STRING) && node.op.match(new BinaryOp.MatchBlockWithDefault<Boolean>(){

                    @Override
                    public Boolean _case(BinaryOp.Addition x) {
                        return true;
                    }

                    @Override
                    protected Boolean _default(BinaryOp x) {
                        return false;
                    }
                }) != false);
            }
        }, false);
    }
}

