/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;

public class AssignmentExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Loc loc;

    public AssignmentExpression(AstNode definingNode, Expr.AssignmentExpr expr) {
        super(definingNode);
        this.left = AssignmentExpression.createStore(this, expr);
        this.right = AssignmentExpression.createAssignment(this, expr);
        this.loc = Location.from(expr);
    }

    private static Expression createStore(AssignmentExpression definingNode, Expr.AssignmentExpr expr) {
        final Expression left = AstNodeFactory.createStore(definingNode, expr.left);
        if (expr != null) {
            expr.op._switch(new AssignmentOp.SwitchBlock(){

                @Override
                public void _case(AssignmentOp.Equals op) {
                }

                @Override
                public void _case(AssignmentOp.OpEquals op) {
                    left.getOptions().isSpecialAssignment = true;
                }
            });
        }
        return left;
    }

    private static Expression createAssignment(final AssignmentExpression definingNode, final Expr.AssignmentExpr expr) {
        return expr.op == null ? Expression.INVALID : expr.op.match(new AssignmentOp.MatchBlock<Expression>(){

            @Override
            public Expression _case(AssignmentOp.Equals op) {
                return AstNodeFactory.create((AstNode)definingNode, expr.right);
            }

            @Override
            public Expression _case(AssignmentOp.OpEquals op) {
                Expression left = AstNodeFactory.create((AstNode)definingNode, expr.left);
                left.getOptions().isSpecialAssignment = true;
                return new BinaryExpression(definingNode, Location.from(expr.left), left, op.op, AstNodeFactory.create((AstNode)definingNode, expr.right));
            }
        });
    }

    private TypeConversion.Conversion convert(Emitter emitter) {
        return ExpressionUtil.isArrayStoreExpression(this.left) && this.left.getType().getBasicType() != BasicType.SOBJECT ? TypeConversion.Conversion.CAST : TypeConversion.emit(this.loc, emitter, this.right.getType(), this.getType());
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.right.validate(symbols, scope);
        this.left.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.right, this.left)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (Distance.get().canAssign(this.getDefiningType(), this.right.getType(), this.left.getType())) {
            this.setType(this.left.getType());
        } else {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.assignment", this.right.getType(), this.left.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.right.emit(emitter);
        if (this.convert(emitter).emitCheckCast()) {
            emitter.emitType(this.loc, 192, TypeConversion.checkCastType(this.getType()));
        }
        if (!this.isTopLevel()) {
            emitter.emit(this.loc, 89);
        }
        this.left.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

