/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.JadtFactory;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SuppressCodeLocationsCalculatorTest {
    private static final ModifierGroup TEST_SETUP = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("testSetup")).build().resolve();
    private static final ModifierGroup TEST_METHOD = ModifierGroup.builder().addModifiers(ModifierTypeInfos.TEST_METHOD).build();
    @Mock
    private MethodInfo methodInfo;
    @Mock
    private TypeInfo definingType;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCodeLocationsSuppressedWhenMethodIsTest() {
        PowerMockito.when((Object)this.methodInfo.getModifiers()).thenReturn((Object)TEST_METHOD);
        MatcherAssert.assertThat((Object)new MethodStack.SuppressCodeLocationsCalculator(this.methodInfo).shouldSuppressCodeLocations(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCodeLocationsSuppressedWhenEnclosingTypeIsTestSetup() {
        PowerMockito.when((Object)this.methodInfo.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        PowerMockito.when((Object)this.methodInfo.getDefiningType()).thenReturn((Object)this.definingType);
        PowerMockito.when((Object)this.definingType.getModifiers()).thenReturn((Object)TEST_SETUP);
        MatcherAssert.assertThat((Object)new MethodStack.SuppressCodeLocationsCalculator(this.methodInfo).shouldSuppressCodeLocations(), (Matcher)Matchers.is((Object)true));
    }

    @DataProvider
    Object[][] codeLocationsSuppressed() {
        return new Object[][]{{UnitType.ANONYMOUS, "__sfdc__proxy_blah_blah", true}, {UnitType.UNRESOLVED, "__sfdc__proxy_blah_blah", false}, {UnitType.ANONYMOUS, "execute", true}, {UnitType.CLASS, "someMethod", false}};
    }

    @Test(dataProvider="codeLocationsSuppressed")
    public void testCodeLocationsSuppressed(UnitType unitType, String name, boolean expected) {
        PowerMockito.when((Object)this.methodInfo.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        PowerMockito.when((Object)this.definingType.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        PowerMockito.when((Object)this.methodInfo.getDefiningType()).thenReturn((Object)this.definingType);
        PowerMockito.when((Object)((Object)this.definingType.getUnitType())).thenReturn((Object)unitType);
        PowerMockito.when((Object)this.methodInfo.getName()).thenReturn((Object)name);
        MatcherAssert.assertThat((Object)new MethodStack.SuppressCodeLocationsCalculator(this.methodInfo).shouldSuppressCodeLocations(), (Matcher)Matchers.is((Object)expected));
    }
}

