/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.JadtTester;
import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.ProxyMethodTable;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProxyMethodTableTest {
    private static final MethodInfo STATIC = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).setModifiers(ModifierGroups.GLOBAL_STATIC).setReturnType(TypeInfos.BOOLEAN).build();
    private static final MethodInfo CONSTRUCTOR = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setConstructor().build();
    private static final MethodInfo NON_STATIC = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setReturnType(TypeInfos.BOOLEAN).setParameters(Parameter.builder().setDefiningType(TypeInfos.INTEGER).setName("foo").setType(TypeInfos.STRING).build()).build();
    private static final Loc LOC = JadtTester.loc((int)0, (int)5);
    private static final TypeInfo TYPE = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("foo")).buildResolved();
    @Mock
    private Emitter emitter;
    private ProxyMethodTable table;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.emitter.getType()).thenReturn((Object)TYPE);
        this.table = new ProxyMethodTable(this.emitter);
    }

    @Test
    public void testGetNotAnonymous() {
        this.table.setProxy(false);
        MethodInfo method = this.table.get(LOC, TYPE, TypeInfos.INTEGER, CONSTRUCTOR);
        MatcherAssert.assertThat((Object)method, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetAnonymous() {
        this.table.setProxy(true);
        MethodInfo method = this.table.get(LOC, TYPE, TypeInfos.INTEGER, CONSTRUCTOR);
        MatcherAssert.assertThat((Object)method, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testConstructor() {
        MethodInfo method = this.table.create(LOC, TYPE, TypeInfos.INTEGER, CONSTRUCTOR);
        MatcherAssert.assertThat((Object)method.getName(), (Matcher)Matchers.is((Object)"__sfdc__proxy_0"));
        MatcherAssert.assertThat((Object)method.getLoc(), (Matcher)Matchers.is((Object)LOC));
        MatcherAssert.assertThat((Object)method.getReturnType(), IsType.isType(TypeInfos.VOID));
        MatcherAssert.assertThat((Object)method.getDefiningType(), IsType.isType(TYPE));
        MatcherAssert.assertThat((Object)method.getModifiers(), (Matcher)Matchers.is((Object)ProxyMethodTable.MODIFIERS));
        MatcherAssert.assertThat((Object)((Object)method.getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.ANONYMOUS)));
        MatcherAssert.assertThat(method.getParameterTypes(), IsType.containsTypes(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)this.table.parameterSize(CONSTRUCTOR), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testStatic() {
        MethodInfo method = this.table.create(LOC, TYPE, TypeInfos.INTEGER, STATIC);
        MatcherAssert.assertThat((Object)method.getName(), (Matcher)Matchers.is((Object)"__sfdc__proxy_0"));
        MatcherAssert.assertThat((Object)method.getLoc(), (Matcher)Matchers.is((Object)LOC));
        MatcherAssert.assertThat((Object)method.getReturnType(), IsType.isType(TypeInfos.BOOLEAN));
        MatcherAssert.assertThat((Object)method.getDefiningType(), IsType.isType(TYPE));
        MatcherAssert.assertThat((Object)method.getModifiers(), (Matcher)Matchers.is((Object)ProxyMethodTable.MODIFIERS));
        MatcherAssert.assertThat((Object)((Object)method.getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.ANONYMOUS)));
        MatcherAssert.assertThat(method.getParameters(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.table.parameterSize(STATIC), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNonStatic() {
        MethodInfo method = this.table.create(LOC, TYPE, TypeInfos.INTEGER, NON_STATIC);
        MatcherAssert.assertThat((Object)method.getName(), (Matcher)Matchers.is((Object)"__sfdc__proxy_0"));
        MatcherAssert.assertThat((Object)method.getLoc(), (Matcher)Matchers.is((Object)LOC));
        MatcherAssert.assertThat((Object)method.getReturnType(), IsType.isType(TypeInfos.BOOLEAN));
        MatcherAssert.assertThat((Object)method.getDefiningType(), IsType.isType(TYPE));
        MatcherAssert.assertThat((Object)method.getModifiers(), (Matcher)Matchers.is((Object)ProxyMethodTable.MODIFIERS));
        MatcherAssert.assertThat((Object)((Object)method.getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.ANONYMOUS)));
        MatcherAssert.assertThat(method.getParameterTypes(), IsType.containsTypes(TypeInfos.INTEGER, TypeInfos.STRING));
        MatcherAssert.assertThat((Object)this.table.parameterSize(NON_STATIC), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testRemoveName() {
        Parameter parameter1 = Parameter.builder().setDefiningType(TYPE).setName("foo").setType(TypeInfos.OBJECT).build();
        Parameter parameter2 = Parameter.builder().setDefiningType(TYPE).setName("foo").setType(TypeInfos.INTEGER).build();
        Parameter parameter3 = Parameter.builder().setDefiningType(TYPE).setName("foo").setType(TypeInfos.BLOB).build();
        ArrayList<Parameter> parameters = Lists.newArrayList(parameter1, parameter2, parameter3);
        List<Parameter> modifiedParameters = ProxyMethodTable.removeNames(parameters);
        MatcherAssert.assertThat(modifiedParameters, (Matcher)Matchers.hasSize((int)3));
        this.assertProperlyRemovedName(parameter1, modifiedParameters.get(0));
        this.assertProperlyRemovedName(parameter2, modifiedParameters.get(1));
        this.assertProperlyRemovedName(parameter3, modifiedParameters.get(2));
    }

    private void assertProperlyRemovedName(Parameter old, Parameter modified) {
        MatcherAssert.assertThat((Object)modified.getName().value, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)modified.getName().loc, (Matcher)Matchers.is((Object)JadtTester.NO_LOC));
        MatcherAssert.assertThat((Object)modified.getType(), (Matcher)Matchers.is((Object)old.getType()));
        MatcherAssert.assertThat((Object)modified.getModifierInfo(), (Matcher)Matchers.is((Object)old.getModifierInfo()));
    }
}

