/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import com.google.common.collect.Queues;
import java.util.Deque;
import shaded.org.objectweb.asm.Label;

public class LoopStack {
    private final Emitter emitter;
    private final Deque<LoopContext> quack;

    public LoopStack(Emitter emitter) {
        this.emitter = emitter;
        this.quack = Queues.newArrayDeque();
    }

    public void emitBreak(Loc breakLoc) {
        LoopContext loop = this.peek();
        this.emitter.getTryCatchFinallyStack().emitFinallyJumps(loop.tryStackSize);
        this.emitter.emitJump(breakLoc, 167, loop.breakLabel);
    }

    public void emitContinue(Loc continueLoc) {
        LoopContext loop = this.peek();
        this.emitter.getTryCatchFinallyStack().emitFinallyJumps(loop.tryStackSize);
        this.emitter.emitJump(continueLoc, 167, loop.continueLabel);
    }

    public void push(LoopContext loop) {
        this.quack.push(loop);
    }

    public LoopContext pop() {
        LoopContext loop = this.quack.pop();
        this.emitter.emit(loop.breakLabel);
        return loop;
    }

    private LoopContext peek() {
        return this.quack.peek();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public static class LoopContext {
        private final Emitter emitter;
        private final Loc locIncrement;
        private final Loc locStatementExecuted;
        private int tryStackSize;
        private final Label breakLabel;
        private final Label continueLabel;
        private int iterationCounterPosition;

        public LoopContext(Emitter emitter, Loc locIncrement, Loc locStatementExecuted) {
            this.emitter = emitter;
            this.locIncrement = locIncrement;
            this.locStatementExecuted = locStatementExecuted;
            this.breakLabel = new Label();
            this.continueLabel = new Label();
            this.iterationCounterPosition = -1;
        }

        public void setTryStackSize() {
            this.tryStackSize = this.emitter.getTryCatchFinallyStack().size();
        }

        public void emitContinueLabel() {
            this.emitter.emit(this.continueLabel);
        }

        public void emitZeroIterationCounter() {
            assert (this.iterationCounterPosition >= 0) : "Can't checkTypes zero iterations if it hasn't been initialized.";
            this.emitter.emitVar(Loc._SyntheticLoc(), 21, this.iterationCounterPosition);
            Label branch = new Label();
            this.emitter.emitJump(Loc._SyntheticLoc(), 154, branch);
            this.emitter.emitStatementExecuted(this.locStatementExecuted, true, false);
            this.emitter.emit(branch);
            this.emitter.getMethodStack().peek().getLocalVariables().clear(this.iterationCounterPosition);
        }

        public void emitIterationCounter() {
            this.iterationCounterPosition = this.emitter.getMethodStack().peek().getLocalVariables().get();
            this.emitter.push(Loc._SyntheticLoc(), 0);
            this.emitter.emitVar(Loc._SyntheticLoc(), 54, this.iterationCounterPosition);
        }

        public void emitIterationCounterIncrement() {
            assert (this.iterationCounterPosition >= 0) : "Can't increment the iteration counter if it hasn't been initialized.";
            this.emitter.emitIinc(this.locIncrement, this.iterationCounterPosition, 1);
        }
    }
}

