/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.AnnotationVisitor;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.context.ProxyMethodTable;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.BooleanMethods;
import apex.jorje.semantic.bcl.DoubleMethods;
import apex.jorje.semantic.bcl.IntegerMethods;
import apex.jorje.semantic.bcl.LongMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.Version;
import shaded.org.objectweb.asm.Label;

public class Emitter {
    private final TryCatchFinallyStack tryCatchFinallyStack = new TryCatchFinallyStack(this);
    private final LoopStack loopStack = new LoopStack(this);
    private final TypeStack typeStack = new TypeStack();
    private final MethodStack methodStack = new MethodStack();
    private final AnnotationVisitor annotationVisitor = new AnnotationVisitor();
    private final ProxyMethodTable proxyMethodTable = new ProxyMethodTable(this);
    private FieldInfo emitRawProperty = null;
    private VariableVisitor<?> variableVisitor;
    private boolean suppressLocation = false;
    private CodeUnit codeUnit;

    public TryCatchFinallyStack getTryCatchFinallyStack() {
        return this.tryCatchFinallyStack;
    }

    public LoopStack getLoopStack() {
        return this.loopStack;
    }

    public TypeStack getTypeStack() {
        return this.typeStack;
    }

    public MethodStack getMethodStack() {
        return this.methodStack;
    }

    public AnnotationVisitor getAnnotationVisitor() {
        return this.annotationVisitor;
    }

    public void assertEmpty() {
        assert (this.tryCatchFinallyStack.isEmpty());
        assert (this.loopStack.isEmpty());
        assert (this.typeStack.isEmpty());
        assert (this.methodStack.isEmpty());
        assert (this.codeUnit == null);
    }

    public void setCodeUnit(CodeUnit codeUnit) {
        this.codeUnit = codeUnit;
    }

    public CodeUnit getCodeUnit() {
        return this.codeUnit;
    }

    public void setSuppressLocation(boolean suppressLocation) {
        this.suppressLocation = suppressLocation;
    }

    public boolean getSuppressLocation() {
        return this.suppressLocation;
    }

    public FieldInfo emitRawProperty() {
        return this.emitRawProperty;
    }

    public void setEmitRawProperty(FieldInfo emitRawProperty) {
        this.emitRawProperty = emitRawProperty;
    }

    private void emitLineNumber(Loc loc) {
        loc._switch(new Loc.SwitchBlock(){

            @Override
            public void _case(Loc.RealLoc x) {
                Emitter.this.emitPending();
                Label label = new Label();
                Emitter.this.emit(label);
                Emitter.this.methodStack.peek().getGeneratorAdapter().visitLineNumber(x.line, label);
                TypeStack.TypeContext typeContext = Emitter.this.typeStack.peek();
                MethodStack.MethodContext methodContext = Emitter.this.methodStack.peek();
                boolean added = typeContext.setKnownCodeLocations(x.line);
                if (methodContext.shouldSuppressCodeLocations() || Emitter.this.suppressLocation) {
                    if (added) {
                        typeContext.addSuppressedCodeLocation(x.line);
                    }
                } else {
                    typeContext.removeSuppressedCodeLocation(x.line);
                }
            }

            @Override
            public void _case(Loc.SyntheticLoc x) {
                Emitter.this.emitPending();
            }
        });
    }

    private void emitPending() {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingBox() != null) {
            assert (method.getPendingUnbox() == null);
            TypeInfo temp = method.getPendingBox();
            method.setPendingBox(null);
            this.emitBox(temp);
        } else if (method.getPendingUnbox() != null) {
            TypeInfo temp = method.getPendingUnbox();
            method.setPendingUnbox(null);
            this.emitUnbox(temp);
        }
    }

    public void unbox(TypeInfo type) {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingBox() != null) {
            assert (method.getPendingBox() == type);
            method.setPendingBox(null);
        } else {
            method.setPendingUnbox(type);
        }
    }

    public void box(TypeInfo type) {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingUnbox() != null) {
            assert (method.getPendingUnbox() == type);
            method.setPendingUnbox(null);
        } else {
            method.setPendingBox(type);
        }
    }

    public void emitStatementExecuted(final Loc loc, final boolean zeroStatements, final boolean trackCodeCoverage) {
        loc._switch(new Loc.SwitchBlock(){

            @Override
            public void _case(Loc.RealLoc x) {
                int value = zeroStatements ? x.line : -x.line;
                Loc nextLoc = trackCodeCoverage ? loc : Loc._SyntheticLoc();
                Emitter.this.push(nextLoc, value);
                Emitter.this.box(TypeInfos.INTEGER);
                Emitter.this.emit(nextLoc, SystemMethods.statementExecuted());
            }

            @Override
            public void _case(Loc.SyntheticLoc x) {
            }
        });
    }

    public void emitAdditionalCodeLocation(Loc loc, final String typeName) {
        loc._switch(new Loc.SwitchBlock(){

            @Override
            public void _case(Loc.RealLoc x) {
                Emitter.this.typeStack.peek().addAdditionalCodeLocation(x.line);
                Emitter.this.push(Loc._SyntheticLoc(), typeName);
                Emitter.this.push(Loc._SyntheticLoc(), x.line);
                Emitter.this.box(TypeInfos.INTEGER);
                Emitter.this.emit(Loc._SyntheticLoc(), SystemMethods.additionalCodeLocationCovered());
            }

            @Override
            public void _case(Loc.SyntheticLoc x) {
            }
        });
    }

    public void emitField(Loc loc, int opcode, String className, String fieldName, String typeSignature) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitFieldInsn(opcode, className, fieldName, typeSignature);
    }

    public void emitField(Loc loc, int opcode, FieldInfo variable) {
        this.emitField(loc, opcode, variable.getDefiningType().getBytecodeName(), variable.getBytecodeName(), variable.getEmitType().getTypeSignature());
    }

    public void emitVar(Loc loc, int opcode, int position) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitVarInsn(opcode, position);
    }

    public void emitJump(Loc loc, int opcode, Label branch) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitJumpInsn(opcode, branch);
    }

    public void emitType(Loc loc, int opcode, TypeInfo type) {
        this.emitType(loc, opcode, type.getBytecodeName());
    }

    public void emitType(Loc loc, int opcode, String signature) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitTypeInsn(opcode, signature);
    }

    public void emitIinc(Loc loc, int position, int value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitIincInsn(position, value);
    }

    public void emit(Loc loc, int opcode) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitInsn(opcode);
    }

    public void emit(Loc loc, AsmMethod method) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitMethodInsn(method.opcode, method.definingType, method.function, method.signature.getValue(), method.definerInterface);
    }

    public void emit(Label branch) {
        this.emitPending();
        this.methodStack.peek().getGeneratorAdapter().visitLabel(branch);
    }

    public void push(Loc loc, String value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Loc loc, int value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Loc loc, long value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Loc loc, double value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Loc loc, boolean value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    private void emitUnbox(TypeInfo pendingUnbox) {
        switch (pendingUnbox.getBasicType()) {
            case INTEGER: {
                this.emit(Loc._SyntheticLoc(), IntegerMethods.intValue());
                break;
            }
            case LONG: {
                this.emit(Loc._SyntheticLoc(), LongMethods.longValue());
                break;
            }
            case DOUBLE: {
                this.emit(Loc._SyntheticLoc(), DoubleMethods.doubleValue());
                break;
            }
            case BOOLEAN: {
                this.emit(Loc._SyntheticLoc(), BooleanMethods.booleanValue());
                break;
            }
        }
    }

    public void emitBox(TypeInfo pendingBox) {
        switch (pendingBox.getBasicType()) {
            case INTEGER: {
                this.emit(Loc._SyntheticLoc(), IntegerMethods.valueOf());
                break;
            }
            case LONG: {
                this.emit(Loc._SyntheticLoc(), LongMethods.valueOf());
                break;
            }
            case DOUBLE: {
                this.emit(Loc._SyntheticLoc(), DoubleMethods.valueOf());
                break;
            }
            case BOOLEAN: {
                this.emit(Loc._SyntheticLoc(), BooleanMethods.valueOf());
                break;
            }
        }
    }

    public void emitCatchBlock(Label tryStart, Label tryEnd, Label handlerStart, TypeInfo type) {
        this.methodStack.peek().getGeneratorAdapter().visitTryCatchBlock(tryStart, tryEnd, handlerStart, type.getBytecodeName());
    }

    public void emitFinallyBlock(Label tryStart, Label tryEnd, Label handlerStart) {
        this.methodStack.peek().getGeneratorAdapter().visitTryCatchBlock(tryStart, tryEnd, handlerStart, null);
    }

    public void emitLocalVariable(String name, TypeInfo type, int position) {
        if (name != null) {
            Label label = new Label();
            this.emit(label);
            this.methodStack.peek().getGeneratorAdapter().visitLocalVariable(name, type.getTypeSignature(), null, label, label, position);
        }
    }

    public ProxyMethodTable getProxyMethodTable() {
        return this.proxyMethodTable;
    }

    public Version getVersion() {
        return this.getTypeStack().peek().getCodeUnitDetails().getVersion();
    }

    public TypeInfo getType() {
        return this.getTypeStack().peek().getType();
    }

    public VariableVisitor<?> getVariableVisitor() {
        return this.variableVisitor;
    }

    public boolean setVariableVisitor(VariableVisitor variableVisitor) {
        if (variableVisitor == null) {
            this.variableVisitor = null;
            return false;
        }
        if (this.variableVisitor == null) {
            this.variableVisitor = variableVisitor;
            return true;
        }
        return false;
    }
}

