/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.compilation.VirtualMethodsCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.tester.MockTypeEquivalence;
import apex.jorje.semantic.tester.TestModifierGroups;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.semantic.tester.matchers.IsMultiMapWithSize;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VirtualMethodsCreatorTest {
    private static final ModifierGroup ONLY_STATIC = ModifierGroup.builder().addModifiers(ModifierTypeInfos.STATIC).build();
    private static final ModifierGroup ONLY_GLOBAL = ModifierGroup.builder().addModifiers(ModifierTypeInfos.GLOBAL).build();
    private static final ModifierGroup ONLY_PUBLIC = ModifierGroup.builder().addModifiers(ModifierTypeInfos.PUBLIC).build();
    private static final ModifierGroup VIRTUAL_OVERRIDE_GLOBAL = ModifierGroup.builder().addModifiers(ModifierTypeInfos.OVERRIDE, ModifierTypeInfos.VIRTUAL, ModifierTypeInfos.GLOBAL).build();
    private static final ModifierGroup VIRTUAL_OVERRIDE_PRIVATE = ModifierGroup.builder().addModifiers(ModifierTypeInfos.OVERRIDE, ModifierTypeInfos.VIRTUAL, ModifierTypeInfos.PRIVATE).build();
    private static final MethodInfo EQUALS = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("equals").setReturnType(InternalTypeInfos.APEX_OBJECT).setGenerated(Generated.USER).setModifiers(ONLY_GLOBAL).setNamedParameterTypes(TypeInfos.BOOLEAN).build();
    private static final MethodInfo HASHCODE = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("equals").setReturnType(InternalTypeInfos.APEX_OBJECT).setGenerated(Generated.USER).setModifiers(ONLY_PUBLIC).setNamedParameterTypes(TypeInfos.BOOLEAN).build();
    private static final MethodInfo HASH_CODE = StandardMethodInfo.builder().setDefiningType(InternalTypeInfos.APEX_OBJECT).setName("hashCode").setReturnType(InternalTypeInfos.APEX_OBJECT).setGenerated(Generated.USER).setModifiers(ONLY_GLOBAL).build();
    private static final TypeRef SUPER_NAME = JadtTester.type((String)JadtTester.BAR_ID.value, (String[])new String[0]);
    @Mock
    private SymbolResolver symbols;
    @Mock
    private CodeUnitDetails codeUnitDetails;
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo superType;
    private MethodTable virtualTable;
    private MethodTable superVirtualTable;
    private MethodTable methods;
    private Multimap<TypeInfo, CompilationException> errorMap;
    private Signature fooSignature;

    private static MethodInfo createFooInteger(TypeInfo definingType, ModifierGroup modifiers) {
        return StandardMethodInfo.builder().setDefiningType(definingType).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(modifiers).build();
    }

    private static MethodInfo createFooString(TypeInfo definingType) {
        return StandardMethodInfo.builder().setDefiningType(definingType).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.STRING).setGenerated(Generated.USER).setModifiers(VIRTUAL_OVERRIDE_GLOBAL).build();
    }

    private static MethodInfo createFooConstructor(TypeInfo definingType) {
        return StandardMethodInfo.builder().setDefiningType(definingType).setConstructor().setName(JadtTester.FOO_ID).setGenerated(Generated.USER).setModifiers(ONLY_GLOBAL).build();
    }

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.virtualTable = new StandardMethodTable();
        this.superVirtualTable = new StandardMethodTable();
        this.methods = new StandardMethodTable();
        StandardParentTable parents = new StandardParentTable();
        Mockito.when((Object)this.codeUnitDetails.isApexSourceBased()).thenReturn((Object)true);
        parents.resolve(null, Collections.emptySet(), false);
        Mockito.when((Object)this.type.getCodeUnitDetails()).thenReturn((Object)this.codeUnitDetails);
        Mockito.when((Object)this.type.parents()).thenReturn((Object)parents);
        Mockito.when((Object)this.type.methods()).thenReturn((Object)this.methods);
        Mockito.when((Object)this.type.virtualMethods()).thenReturn((Object)this.virtualTable);
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)TestModifierGroups.EMPTY);
        Mockito.when(this.type.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)true);
        Mockito.when(this.type.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)this.type);
        Mockito.when(this.type.accept(TypeInfoEquivalence.CalculateEquivalenceInputTypeVisitor.get())).thenReturn((Object)MockTypeEquivalence.get());
        StandardParentTable superParents = new StandardParentTable();
        superParents.resolve(null, Collections.emptySet(), false);
        StandardMethodTable superMethods = new StandardMethodTable();
        Mockito.when((Object)this.superType.methods()).thenReturn((Object)superMethods);
        Mockito.when((Object)this.superType.parents()).thenReturn((Object)superParents);
        Mockito.when((Object)this.superType.virtualMethods()).thenReturn((Object)this.superVirtualTable);
        Mockito.when((Object)this.superType.getModifiers()).thenReturn((Object)TestModifierGroups.EMPTY);
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)true);
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)this.superType);
        Mockito.when((Object)this.superType.accept(MockTypeEquivalence.get())).thenReturn((Object)false);
        Mockito.when(this.superType.accept(TypeInfoEquivalence.CalculateEquivalenceInputTypeVisitor.get())).thenReturn((Object)MockTypeEquivalence.get());
        Mockito.when((Object)this.symbols.lookupTypeInfo(this.type, SUPER_NAME)).thenReturn((Object)this.superType);
        this.errorMap = LinkedListMultimap.create();
        this.fooSignature = SignatureFactory.createWithDefiningType(JadtTester.FOO_ID.value, this.type, (TypeInfo)TypeInfos.INTEGER, new TypeInfo[0]);
    }

    private void resolveParents() {
        StandardParentTable parents = new StandardParentTable();
        Mockito.when((Object)this.type.parents()).thenReturn((Object)parents);
        parents.resolve(this.superType, Collections.emptySet(), false);
    }

    @Test
    public void testResolvedVirtualTableIsNotAltered() {
        this.virtualTable.resolve();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
        MatcherAssert.assertThat(this.virtualTable.all(), (Matcher)Matchers.empty());
    }

    @Test
    public void testCreateDoesNotThrow() {
        this.methods.addNoDuplicatesAllowed(VirtualMethodsCreatorTest.createFooInteger(this.type, ONLY_GLOBAL)).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
    }

    @Test
    public void testCreateWithParent() {
        this.resolveParents();
        MethodInfo method = VirtualMethodsCreatorTest.createFooInteger(this.type, VIRTUAL_OVERRIDE_GLOBAL);
        this.methods.addNoDuplicatesAllowed(method).throwIfError();
        this.superVirtualTable.addNoDuplicatesAllowed(VirtualMethodsCreatorTest.createFooInteger(this.superType, VIRTUAL_OVERRIDE_GLOBAL)).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
        MatcherAssert.assertThat(this.type.virtualMethods().all(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)this.type.virtualMethods().get(this.fooSignature), (Matcher)Matchers.is((Object)method));
    }

    @Test
    public void testDifferentReturnTypes() {
        this.resolveParents();
        this.methods.addNoDuplicatesAllowed(VirtualMethodsCreatorTest.createFooInteger(this.type, VIRTUAL_OVERRIDE_GLOBAL)).throwIfError();
        this.superVirtualTable.addNoDuplicatesAllowed(VirtualMethodsCreatorTest.createFooString(this.superType)).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, ErrorMatchers.containsMultiErrors(I18nSupport.getLabel("method.types.clash", TypeInfos.INTEGER, TypeInfos.STRING, "type")));
    }

    @Test
    public void testNoOverrideProvided() {
        this.assertMethodError(VirtualMethodsCreatorTest.createFooInteger(this.type, ONLY_GLOBAL), VirtualMethodsCreatorTest.createFooInteger(this.superType, VIRTUAL_OVERRIDE_GLOBAL), I18nSupport.getLabel("methods.must.override", this.fooSignature));
    }

    @Test
    public void testLowerVisibility() {
        this.assertMethodError(VirtualMethodsCreatorTest.createFooInteger(this.type, VIRTUAL_OVERRIDE_PRIVATE), VirtualMethodsCreatorTest.createFooInteger(this.superType, VIRTUAL_OVERRIDE_GLOBAL), I18nSupport.getLabel("cannot.reduce.method.visibility.override", this.fooSignature));
    }

    @Test
    public void testLowerVisibilityBuiltInAdded() {
        this.assertMethodAdded(HASHCODE);
    }

    @Test
    public void testNoOverrideNeededVisibility() {
        this.assertMethodError(VirtualMethodsCreatorTest.createFooInteger(this.type, VIRTUAL_OVERRIDE_GLOBAL), VirtualMethodsCreatorTest.createFooInteger(this.superType, VIRTUAL_OVERRIDE_PRIVATE), I18nSupport.getLabel("method.does.not.override", this.fooSignature));
    }

    private void assertMethodError(MethodInfo myMethod, MethodInfo parentMethod, String error) {
        this.resolveParents();
        this.methods.addNoDuplicatesAllowed(myMethod).throwIfError();
        this.superVirtualTable.addNoDuplicatesAllowed(parentMethod).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, ErrorMatchers.containsMultiErrors(error));
    }

    @Test
    public void testNoOverrideNeeded() {
        this.methods.addNoDuplicatesAllowed(VirtualMethodsCreatorTest.createFooInteger(this.type, VIRTUAL_OVERRIDE_GLOBAL)).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, ErrorMatchers.containsMultiErrors(I18nSupport.getLabel("method.does.not.override", this.fooSignature)));
    }

    @Test
    public void testConstructors() {
        this.assertMethodNotAdded(VirtualMethodsCreatorTest.createFooConstructor(this.type));
    }

    @Test
    public void testStatics() {
        this.assertMethodNotAdded(VirtualMethodsCreatorTest.createFooInteger(this.type, ONLY_STATIC));
    }

    private void assertMethodNotAdded(MethodInfo method) {
        this.methods.addNoDuplicatesAllowed(method).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
        MatcherAssert.assertThat(this.type.virtualMethods().all(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)this.type.virtualMethods().get(method.getSignature()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testRemoveObjectHashCode() {
        this.assertMethodAdded(HASH_CODE);
    }

    @Test
    public void testRemoveObjectEquals() {
        this.assertMethodAdded(EQUALS);
    }

    private void assertMethodAdded(MethodInfo method) {
        this.methods.addNoDuplicatesAllowed(method).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
        MatcherAssert.assertThat(this.type.virtualMethods().all(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)this.type.virtualMethods().get(method.getSignature()), (Matcher)Matchers.is((Object)method));
    }

    @Test
    public void testOverrideObjectEqualsRequiresNoOverride() {
        Mockito.when((Object)this.superType.getBytecodeName()).thenReturn((Object)InternalTypeInfos.APEX_OBJECT.getBytecodeName());
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.anyObject())).thenReturn((Object)this.superVirtualTable);
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)true);
        this.methods.addNoDuplicatesAllowed(StandardMethodInfo.builder().setDefiningType(this.type).setReturnType(TypeInfos.BOOLEAN).setName("equals").setNamedParameterTypes(TypeInfos.OBJECT).setModifiers(ModifierGroups.GLOBAL).setGenerated(Generated.USER).build());
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
    }

    @Test
    public void testOverrideObjectHashCodeRequiresNoOverride() {
        Mockito.when((Object)this.superType.getBytecodeName()).thenReturn((Object)InternalTypeInfos.APEX_OBJECT.getBytecodeName());
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.anyObject())).thenReturn((Object)this.superVirtualTable);
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)true);
        this.methods.addNoDuplicatesAllowed(StandardMethodInfo.builder().setDefiningType(this.type).setReturnType(TypeInfos.INTEGER).setName("hashCode").setModifiers(ModifierGroups.GLOBAL).setGenerated(Generated.USER).build()).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, IsMultiMapWithSize.anEmptyMultiMap());
    }

    @Test
    public void testOverrideObjectToStringRequiresOverride() {
        Mockito.when((Object)this.superType.getBytecodeName()).thenReturn((Object)InternalTypeInfos.APEX_OBJECT.getBytecodeName());
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.anyObject())).thenReturn((Object)this.superVirtualTable);
        Mockito.when(this.superType.accept((TypeInfoVisitor)org.mockito.Matchers.any())).thenReturn((Object)true);
        MethodInfo toString = StandardMethodInfo.builder().setDefiningType(this.type).setReturnType(TypeInfos.STRING).setName("toString").setModifiers(ModifierGroups.GLOBAL).setGenerated(Generated.USER).build();
        this.methods.addNoDuplicatesAllowed(toString).throwIfError();
        VirtualMethodsCreator.create(this.errorMap, this.type);
        MatcherAssert.assertThat(this.errorMap, ErrorMatchers.containsMultiErrors(I18nSupport.getLabel("methods.must.override", toString.getSignature().getApexValue())));
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public virtual class Foo { public abstract class fooWrapper{ public void m(){} } class Bar extends FooWrapper { public override void m(){} } }", I18nSupport.getLabel("non.virtual.methods.cannot.override", "void Foo.Bar.m()")}, {"public virtual class Foo { virtual void m(){} class Bar extends Foo { public void m(){} } } ", I18nSupport.getLabel("methods.must.override", "void Foo.Bar.m()")}, {"public virtual class Foo { void m1(){} class Bar extends Foo { public override void m(){} } } ", I18nSupport.getLabel("method.does.not.override", "void Foo.Bar.m()")}, {"public virtual class Foo { public virtual void m(){} class Bar extends Foo { private override void m(){} } } ", I18nSupport.getLabel("cannot.reduce.method.visibility.override", "void Foo.Bar.m()")}, {"public abstract class Foo { abstract void m(); class Bar extends Foo { } } ", I18nSupport.getLabel("class.must.implement.abstract.method", "Foo.Bar", "void Foo.m()")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        ValidationTester tester = new ValidationTester();
        tester.setParserType(ParserWrapper.Type.NAMED);
        tester.assertFailure(code, expectedError);
    }
}

