/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.Multimap;

public class VirtualMethodsCreator {
    private VirtualMethodsCreator() {
    }

    public static void create(Multimap<TypeInfo, CompilationException> errorsMap, TypeInfo type) {
        TypeInfo superType;
        MethodTable virtualMethods = type.virtualMethods();
        if (virtualMethods.isResolved()) {
            return;
        }
        if (type.parents().isResolved() && type.parents().superType() != null) {
            superType = type.parents().superType();
            if (!superType.virtualMethods().isResolved()) {
                VirtualMethodsCreator.create(errorsMap, superType);
            }
        } else {
            superType = TypeInfos.OBJECT;
        }
        for (MethodInfo method2 : superType.virtualMethods().instance()) {
            Result<Void> result = virtualMethods.addNoDuplicatesAllowed(method2);
            if (!result.hasError()) continue;
            errorsMap.put(type, new SemanticException(method2.getLoc(), result.getError()));
        }
        if (type.parents().isResolved() && type.parents().superType() != null) {
            virtualMethods.remove(SignatureFactory.create("clone", type.parents().superType()));
        }
        for (MethodInfo method2 : type.methods().instance()) {
            Result<Void> result;
            boolean isVisible;
            MethodInfo parent = virtualMethods.get(method2.getSignature());
            VirtualMethodsCreator.removeObjectEqualsIfNecessary(virtualMethods, method2);
            VirtualMethodsCreator.removeObjectHashCodeIfNecessary(virtualMethods, method2);
            boolean bl = isVisible = parent != null && Visibility.isMemberVisibleNoTestCheck(method2.getDefiningType(), parent.getDefiningType(), parent.getModifiers());
            if (isVisible && !VirtualMethodsCreator.isSpecial(parent)) {
                boolean hasErrors = false;
                if (parent.getModifiers().none(ModifierTypeInfos.VIRTUAL, ModifierTypeInfos.ABSTRACT)) {
                    errorsMap.put(type, new SemanticException(method2.getLoc(), I18nSupport.getLabel("non.virtual.methods.cannot.override", method2.getSignature().getApexValue())));
                    hasErrors = true;
                }
                if (method2.getModifiers().not(ModifierTypeInfos.OVERRIDE) && VirtualMethodsCreator.overrideIsRequired(parent)) {
                    errorsMap.put(type, new SemanticException(method2.getLoc(), I18nSupport.getLabel("methods.must.override", method2.getSignature())));
                    hasErrors = true;
                }
                if (Visibility.isLowerForOverride(parent.getModifiers(), method2.getModifiers()) && parent.getGenerated() != Generated.BUILT_IN) {
                    errorsMap.put(type, new SemanticException(method2.getLoc(), I18nSupport.getLabel("cannot.reduce.method.visibility.override", method2.getSignature())));
                    continue;
                }
                if (hasErrors) continue;
                method2.setCanonicalName(parent.getCanonicalName());
            } else if (method2.getModifiers().has(ModifierTypeInfos.OVERRIDE)) {
                errorsMap.put(type, new SemanticException(method2.getLoc(), I18nSupport.getLabel("method.does.not.override", method2.getSignature())));
                continue;
            }
            if (!(result = virtualMethods.addDuplicatesAllowed(method2)).hasError()) continue;
            errorsMap.put(type, new SemanticException(method2.getLoc(), result.getError()));
        }
        if (type.getModifiers().not(ModifierTypeInfos.ABSTRACT) && type.getUnitType() == UnitType.CLASS) {
            virtualMethods.instance().stream().filter(method -> method.getModifiers().has(ModifierTypeInfos.ABSTRACT) && method.getDefiningType() != type).forEach(method -> errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("class.must.implement.abstract.method", type, method))));
        }
        virtualMethods.resolve();
    }

    private static boolean isSpecial(MethodInfo parent) {
        return parent.getInvocationType() == InvocationType.SPECIAL;
    }

    private static void removeObjectEqualsIfNecessary(MethodTable methodTable, MethodInfo method) {
        MethodInfo equalsMethod;
        if (method != null && method.getName().equalsIgnoreCase("equals") && method.getParameterTypes().size() == 1 && (equalsMethod = methodTable.get(ObjectMethods.EQUALS_METHOD.get().getSignature())) != null && VirtualMethodsCreator.isObjectOrApexObject(equalsMethod.getDefiningType())) {
            methodTable.remove(equalsMethod.getSignature());
        }
    }

    private static void removeObjectHashCodeIfNecessary(MethodTable methodTable, MethodInfo method) {
        MethodInfo hashCodeMethod;
        if (method != null && method.getName().equalsIgnoreCase("hashCode") && !method.getReturnType().equals(TypeInfos.INTEGER) && method.getParameterTypes().isEmpty() && (hashCodeMethod = methodTable.get(ObjectMethods.HASH_CODE_METHOD.get().getSignature())) != null && VirtualMethodsCreator.isObjectOrApexObject(hashCodeMethod.getDefiningType())) {
            methodTable.remove(hashCodeMethod.getSignature());
        }
    }

    private static boolean isObjectOrApexObject(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_OBJECT) || TypeInfoEquivalence.isEquivalent(type, TypeInfos.OBJECT);
    }

    private static boolean overrideIsRequired(MethodInfo original) {
        return !VirtualMethodsCreator.isObjectOrApexObject(original.getDefiningType()) || !"equals".equalsIgnoreCase(original.getName()) && !"hashCode".equalsIgnoreCase(original.getName());
    }
}

