/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Loc;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Literal;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.MultiStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class UserTriggerMembers {
    private final List<Field> fields;
    private final List<Method> methods;
    private final List<Property> properties;
    private final List<Compilation> innerTypes;

    private UserTriggerMembers(Builder builder) {
        this.fields = builder.fieldBuilder.build();
        this.methods = builder.methodBuilder.build();
        this.properties = builder.propertyBuilder.build();
        this.innerTypes = builder.innerTypesBuilder.build();
    }

    private static Method invoke(UserTrigger node, TypeInfo triggerType, Loc loc, List<AstNode> invokeStatements) {
        MultiStatement root = new MultiStatement(node, Loc._SyntheticLoc(), invokeStatements, emitter -> {
            emitter.emitStatementExecuted(loc, false, false);
            for (AstNode statement : invokeStatements) {
                statement.emit(emitter);
            }
        });
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(triggerType).setReturnType(TypeInfos.VOID).setName("invoke").setModifiers(triggerType.getModifiers()).setGenerated(Generated.INTERNAL).setTriggerInvoke(), root);
    }

    private static Method emptyConstructor(UserTrigger node, TypeInfo triggerType) {
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(triggerType).setConstructor().setName("<init>").setModifiers(triggerType.getModifiers()).setGenerated(Generated.INTERNAL), Statement.NOOP);
    }

    public static UserTriggerMembers create(UserTrigger node, Errors errors, SourceFile source, TypeInfo triggerType, CompilationUnit.TriggerDeclUnit body) {
        Builder builder = new Builder(errors, source, node);
        for (BlockMember member : AstNodeFactory.filterNotNull(body.members.values)) {
            member._switch(builder);
        }
        ((ImmutableList.Builder)builder.methodBuilder.add(UserTriggerMembers.invoke(node, triggerType, body.name.loc, (List<AstNode>)((Object)builder.invokeStatementsBuilder.build())))).add(UserTriggerMembers.emptyConstructor(node, triggerType));
        return new UserTriggerMembers(builder);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Compilation> getInnerTypes() {
        return this.innerTypes;
    }

    private static class Builder
    implements BlockMember.SwitchBlock {
        private final Errors errors;
        private final SourceFile source;
        private final UserTrigger node;
        private final ImmutableList.Builder<AstNode> invokeStatementsBuilder;
        private final ImmutableList.Builder<Field> fieldBuilder;
        private final ImmutableList.Builder<Method> methodBuilder;
        private final ImmutableList.Builder<Property> propertyBuilder;
        private final ImmutableList.Builder<Compilation> innerTypesBuilder;

        private Builder(Errors errors, SourceFile source, UserTrigger node) {
            this.errors = errors;
            this.source = source;
            this.node = node;
            this.invokeStatementsBuilder = ImmutableList.builder();
            this.fieldBuilder = ImmutableList.builder();
            this.methodBuilder = ImmutableList.builder();
            this.propertyBuilder = ImmutableList.builder();
            this.innerTypesBuilder = ImmutableList.builder();
        }

        @Override
        public void _case(BlockMember.StmntBlockMember x) {
            this.invokeStatementsBuilder.add((Object)AstNodeFactory.create((AstNode)this.node, x.stmnt));
        }

        @Override
        public void _case(BlockMember.StaticStmntBlockMember x) {
            throw new UnexpectedCodePathException();
        }

        @Override
        public void _case(BlockMember.FieldMember field) {
            FieldDeclarationStatements statement = AstNodeFactory.create((AstNode)this.node, field.variableDecls);
            this.invokeStatementsBuilder.add((Object)statement);
            this.fieldBuilder.addAll(FieldFactory.createFields(this.node, field.variableDecls));
        }

        @Override
        public void _case(BlockMember.MethodMember method) {
            this.methodBuilder.add((Object)MethodFactory.createUserMethod(this.node, method.methodDecl));
        }

        @Override
        public void _case(BlockMember.PropertyMember property) {
            if (property.propertyDecl != null) {
                this.invokeStatementsBuilder.add((Object)StatementExecuted.createSynthetic(this.node, property.propertyDecl.name.loc, true, false));
                this.invokeStatementsBuilder.add((Object)new LiteralExpression(this.node, new Expr.LiteralExpr(Literal._NullLiteral(property.propertyDecl.name.loc))));
                this.invokeStatementsBuilder.add((Object)VariableExpression.createStore(this.node, JadtFactory.variableExpr(Optional.empty(), property.propertyDecl.name)));
                this.propertyBuilder.add((Object)AstNodeFactory.create(this.errors, this.node, property.propertyDecl));
            }
        }

        @Override
        public void _case(BlockMember.InnerClassMember innerClass) {
            this.invokeStatementsBuilder.add((Object)StatementExecuted.createSynthetic(this.node, innerClass.body.loc, false, false));
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._ClassDeclUnit(innerClass.body)));
        }

        @Override
        public void _case(BlockMember.InnerInterfaceMember innerInterface) {
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._InterfaceDeclUnit(innerInterface.body)));
        }

        @Override
        public void _case(BlockMember.InnerEnumMember innerEnum) {
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._EnumDeclUnit(innerEnum.body)));
        }
    }
}

