/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.TriggerUsageCalculator;
import apex.jorje.semantic.ast.compilation.UserTriggerMembers;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.Constants;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.TriggerUsage;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UserTrigger
extends Compilation {
    private final TypeInfo triggerType;
    private final Loc loc;
    private final Identifier name;
    private final Identifier targetName;
    private final List<TriggerUsage> usages;
    private final UserTriggerMembers members;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;
    private TypeInfo targetType;

    public UserTrigger(Errors errors, SourceFile source, CompilationUnit.TriggerDeclUnit trigger) {
        this.loc = trigger.loc;
        this.name = trigger.name;
        this.triggerType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(source, trigger)).build();
        this.targetName = trigger.target;
        this.usages = TriggerUsageCalculator.get().resolve(errors, this, trigger.usages);
        this.members = UserTriggerMembers.create(this, errors, source, this.triggerType, trigger);
        this.additionalInfo = AdditionalInfo.builder().setDefiningType(this.triggerType).setInnerTypes(this.members.getInnerTypes()).setProperties(this.members.getProperties()).build();
        this.modifiers = new ModifierNode(this, this.triggerType.getModifiers());
    }

    public Identifier getTargetName() {
        return this.targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Compilation innerType : this.members.getInnerTypes()) {
                    innerType.traverse(visitor, scope);
                }
                for (Field field : this.members.getFields()) {
                    field.traverse(visitor, scope);
                }
                for (Property property : this.members.getProperties()) {
                    property.traverse(visitor, scope);
                }
                for (Method method : this.members.getMethods()) {
                    method.traverse(visitor, scope);
                }
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            scope.getErrors().addIfError((AstNode)this, this.name.loc, IdentifierValidator.get().validate(this.triggerType, this.name, IdentifierValidator.Type.TRIGGER, true));
            if (scope.getErrors().isInvalid((AstNode)this)) {
                return;
            }
            TypeInfo foundTypeInfo = symbols.lookupTypeInfoIdentifiers(this.getDefiningType(), ImmutableList.of(Constants.SCHEMA, this.targetName));
            if (!foundTypeInfo.isResolved()) {
                scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(foundTypeInfo));
                return;
            }
            if (!SObjectTypeInfoUtil.isConcreteSObject(foundTypeInfo)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.trigger.object", foundTypeInfo));
                return;
            }
            this.targetType = foundTypeInfo;
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (Field field : this.members.getFields()) {
                field.validate(symbols, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.validate(symbols, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.triggerType);
        output.setTriggerInfo((SObjectTypeInfo)this.targetType, this.usages);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.triggerType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set(clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            for (Field field : this.members.getFields()) {
                field.emit(emitter);
            }
            for (Property property : this.members.getProperties()) {
                property.emit(emitter);
            }
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            this.additionalInfo.emit(emitter);
        }
        finally {
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(clazz.getClassWriter().toByteArray()).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.triggerType;
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public TypeInfo getTargetType() {
        return this.targetType;
    }

    public Identifier getName() {
        return this.name;
    }

    public UserTriggerMembers getMembers() {
        return this.members;
    }
}

