/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UserClassMembers {
    private static final ModifierGroup CLONE_MODIFIERS = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PUBLIC).build();
    private final List<Statement> statements;
    private final List<Field> fields;
    private final List<Method> methods;
    private final List<Property> properties;
    private final List<Compilation> innerTypes;

    private UserClassMembers(Builder builder) {
        this.statements = builder.statementBuilder.build();
        this.fields = builder.fieldBuilder.build();
        this.methods = builder.methodBuilder.build();
        this.properties = builder.propertyBuilder.build();
        this.innerTypes = builder.innerTypesBuilder.build();
    }

    private static Method createClone(UserClass node, TypeInfo classType) {
        SimpleStatement root = new SimpleStatement(node){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.cloneObject());
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(classType).setReturnType(classType).setEmitSignature("clone", TypeInfos.OBJECT, new TypeInfo[0]).setName("clone").setDuckTyped().setModifiers(CLONE_MODIFIERS).setGenerated(Generated.ANONYMOUS), root);
    }

    private static Method createClinit(UserClass node, final TypeInfo classType, Loc loc, final List<Statement> staticStatements) {
        Statement root = new Statement(node){

            @Override
            public final <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
                for (AstNode node : staticStatements) {
                    node.traverse(visitor, scope);
                }
            }

            @Override
            public final void validate(SymbolResolver symbols, ValidationScope scope) {
                for (AstNode node : staticStatements) {
                    node.validate(symbols, scope);
                }
            }

            @Override
            public Loc getLoc() {
                return Loc._SyntheticLoc();
            }

            @Override
            public void emit(Emitter emitter) {
                Emit body = e -> {
                    for (Statement statement : staticStatements) {
                        statement.emit(e);
                    }
                };
                SystemModeEmit.builder().setType(classType).setBody(body).build().emit(emitter);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().setLoc(loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC).build();
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(classType).setReturnType(TypeInfos.VOID).setName("<clinit>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    public static UserClassMembers create(UserClass node, Errors errors, SourceFile source, AstNode definingNode, TypeInfo classType, ClassDecl body) {
        Builder builder = new Builder(errors, source, definingNode, node);
        for (BlockMember member : AstNodeFactory.filterNotNull(body.members.values)) {
            member._switch(builder);
        }
        if (definingNode == null) {
            builder.methodBuilder.add(UserClassMembers.createClinit(node, classType, body.name.loc, (List<Statement>)((Object)builder.staticStatementBuilder.build())));
        }
        builder.methodBuilder.add(UserClassMembers.createClone(node, classType));
        return new UserClassMembers(builder);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Compilation> getInnerTypes() {
        return this.innerTypes;
    }

    private static class Builder
    implements BlockMember.SwitchBlock {
        private final Errors errors;
        private final SourceFile source;
        private final AstNode definingNode;
        private final UserClass node;
        private final ImmutableList.Builder<Statement> staticStatementBuilder;
        private final ImmutableList.Builder<Statement> statementBuilder;
        private final ImmutableList.Builder<Field> fieldBuilder;
        private final ImmutableList.Builder<Method> methodBuilder;
        private final ImmutableList.Builder<Property> propertyBuilder;
        private final ImmutableList.Builder<Compilation> innerTypesBuilder;

        private Builder(Errors errors, SourceFile source, AstNode definingNode, UserClass node) {
            this.errors = errors;
            this.source = source;
            this.definingNode = definingNode;
            this.node = node;
            this.staticStatementBuilder = ImmutableList.builder();
            this.statementBuilder = ImmutableList.builder();
            this.fieldBuilder = ImmutableList.builder();
            this.methodBuilder = ImmutableList.builder();
            this.propertyBuilder = ImmutableList.builder();
            this.innerTypesBuilder = ImmutableList.builder();
        }

        @Override
        public void _case(BlockMember.StmntBlockMember x) {
            this.statementBuilder.add((Object)AstNodeFactory.create((AstNode)this.node, x.stmnt));
        }

        @Override
        public void _case(BlockMember.StaticStmntBlockMember x) {
            if (this.definingNode == null) {
                this.staticStatementBuilder.add((Object)AstNodeFactory.create((AstNode)this.node, x.stmnt));
            } else {
                this.errors.markInvalid((AstNode)this.node, Location.from(x.stmnt), I18nSupport.getLabel("invalid.inner.type.no.static.blocks"));
            }
        }

        @Override
        public void _case(BlockMember.FieldMember field) {
            FieldDeclarationStatements statement = AstNodeFactory.create((AstNode)this.node, field.variableDecls);
            if (statement.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.staticStatementBuilder.add((Object)statement);
            } else {
                this.statementBuilder.add((Object)statement);
            }
            this.fieldBuilder.addAll(FieldFactory.createFields(this.node, field.variableDecls));
        }

        @Override
        public void _case(BlockMember.MethodMember method) {
            this.methodBuilder.add((Object)MethodFactory.createUserMethod(this.node, method.methodDecl));
        }

        @Override
        public void _case(BlockMember.PropertyMember property) {
            if (property.propertyDecl != null) {
                Property theProperty = AstNodeFactory.create(this.errors, this.node, property.propertyDecl);
                if (!theProperty.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    this.statementBuilder.add((Object)StatementExecuted.createSynthetic(this.node, property.propertyDecl.name.loc, true, false));
                }
                this.propertyBuilder.add((Object)theProperty);
            }
        }

        @Override
        public void _case(BlockMember.InnerClassMember innerClass) {
            if (this.definingNode == null) {
                this.staticStatementBuilder.add((Object)StatementExecuted.createSynthetic(this.node, innerClass.body.loc, false, false));
                this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._ClassDeclUnit(innerClass.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerClass.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }

        @Override
        public void _case(BlockMember.InnerInterfaceMember innerInterface) {
            if (this.definingNode == null) {
                this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._InterfaceDeclUnit(innerInterface.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerInterface.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }

        @Override
        public void _case(BlockMember.InnerEnumMember innerEnum) {
            if (this.definingNode == null) {
                this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._EnumDeclUnit(innerEnum.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerEnum.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }
    }
}

