/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.Location;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AnonymousClassMembers {
    private final List<Field> fields;
    private final List<Method> methods;
    private final List<Property> properties;
    private final List<Compilation> innerTypes;

    private AnonymousClassMembers(Builder builder) {
        this.fields = builder.fieldBuilder.build();
        this.methods = builder.methodBuilder.build();
        this.properties = builder.propertyBuilder.build();
        this.innerTypes = builder.innerTypesBuilder.build();
    }

    private static Method execute(AnonymousClass node, TypeInfo classType, final Loc loc, final List<AstNode> executeStatements) {
        Statement root = new Statement(node){

            @Override
            public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
                for (AstNode statement : executeStatements) {
                    statement.traverse(visitor, scope);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void validate(SymbolResolver symbols, ValidationScope scope) {
                scope.pushAnonymousPseudoBlock();
                try {
                    for (AstNode statement : executeStatements) {
                        statement.validate(symbols, scope);
                        if (!scope.getErrors().isInvalid(statement)) continue;
                        scope.getErrors().markInvalid(this);
                    }
                }
                finally {
                    scope.popAnonymousPseudoBlock();
                }
            }

            @Override
            public void emit(Emitter emitter) {
                emitter.emitStatementExecuted(loc, false, false);
                emitter.getProxyMethodTable().setProxy(true);
                for (AstNode statement : executeStatements) {
                    statement.emit(emitter);
                }
                emitter.getProxyMethodTable().setProxy(false);
            }

            @Override
            public Loc getLoc() {
                return loc;
            }
        };
        ModifierGroup newModifiers = classType.getModifiers().copy().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC).build();
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(classType).setReturnType(TypeInfos.VOID).setName("execute").setModifiers(newModifiers).setGenerated(Generated.INTERNAL), root);
    }

    public static AnonymousClassMembers create(AnonymousClass node, Errors errors, SourceFile source, TypeInfo classType, CompilationUnit.AnonymousBlockUnit body) {
        Builder builder = new Builder(errors, source, node);
        for (BlockMember member : AstNodeFactory.filterNotNull(body.members)) {
            member._switch(builder);
        }
        builder.methodBuilder.add(AnonymousClassMembers.execute(node, classType, Location.ANONYMOUS_BLOCK, (List<AstNode>)((Object)builder.statementBuilder.build())));
        return new AnonymousClassMembers(builder);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Compilation> getInnerTypes() {
        return this.innerTypes;
    }

    private static class Builder
    implements BlockMember.SwitchBlock {
        private final Errors errors;
        private final SourceFile source;
        private final AnonymousClass node;
        private final ImmutableList.Builder<AstNode> statementBuilder;
        private final ImmutableList.Builder<Field> fieldBuilder;
        private final ImmutableList.Builder<Method> methodBuilder;
        private final ImmutableList.Builder<Property> propertyBuilder;
        private final ImmutableList.Builder<Compilation> innerTypesBuilder;

        private Builder(Errors errors, SourceFile source, AnonymousClass node) {
            this.errors = errors;
            this.source = source;
            this.node = node;
            this.statementBuilder = ImmutableList.builder();
            this.fieldBuilder = ImmutableList.builder();
            this.methodBuilder = ImmutableList.builder();
            this.propertyBuilder = ImmutableList.builder();
            this.innerTypesBuilder = ImmutableList.builder();
        }

        @Override
        public void _case(BlockMember.StmntBlockMember x) {
            this.statementBuilder.add((Object)AstNodeFactory.create((AstNode)this.node, x.stmnt));
        }

        @Override
        public void _case(BlockMember.StaticStmntBlockMember x) {
            throw new UnexpectedCodePathException();
        }

        @Override
        public void _case(BlockMember.FieldMember field) {
            FieldDeclarationStatements statement = AstNodeFactory.create((AstNode)this.node, field.variableDecls);
            this.statementBuilder.add((Object)statement);
            this.fieldBuilder.addAll(FieldFactory.createFields(this.node, field.variableDecls));
        }

        @Override
        public void _case(BlockMember.MethodMember method) {
            this.methodBuilder.add((Object)MethodFactory.createUserMethod(this.node, method.methodDecl));
        }

        @Override
        public void _case(BlockMember.PropertyMember property) {
            if (property.propertyDecl != null) {
                FieldDeclarationStatements statement = AstNodeFactory.create((AstNode)this.node, property);
                this.statementBuilder.add((Object)statement);
                this.propertyBuilder.add((Object)AstNodeFactory.create(this.errors, this.node, property.propertyDecl));
            }
        }

        @Override
        public void _case(BlockMember.InnerClassMember innerClass) {
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._ClassDeclUnit(innerClass.body)));
        }

        @Override
        public void _case(BlockMember.InnerInterfaceMember innerInterface) {
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._InterfaceDeclUnit(innerInterface.body)));
        }

        @Override
        public void _case(BlockMember.InnerEnumMember innerEnum) {
            this.innerTypesBuilder.add((Object)AstNodeFactory.create(this.errors, this.source, this.node, CompilationUnit._EnumDeclUnit(innerEnum.body)));
        }
    }
}

