/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.AnonymousClassMembers;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;

public class AnonymousClass
extends Compilation {
    private final TypeInfo classType;
    private final Loc loc;
    private final AnonymousClassMembers members;
    private final AdditionalInfo additionalInfo;

    public AnonymousClass(Errors errors, SourceFile source, CompilationUnit.AnonymousBlockUnit anonymousBlock) {
        this.loc = Location.from(anonymousBlock);
        this.classType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(source, anonymousBlock)).build();
        this.members = AnonymousClassMembers.create(this, errors, source, this.classType, anonymousBlock);
        this.additionalInfo = AdditionalInfo.builder().setDefiningType(this.classType).setProperties(this.members.getProperties()).build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.traverse(visitor, scope);
            }
            for (Field field : this.members.getFields()) {
                field.traverse(visitor, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.traverse(visitor, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.traverse(visitor, scope);
            }
            this.additionalInfo.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            if (scope.getErrors().isInvalid((AstNode)this)) {
                return;
            }
            CodeUnitDetails codeUnit = this.classType.getCodeUnitDetails();
            int classSizeLimit = codeUnit.getSource().getSizeLimit();
            if (codeUnit.getSource().getBody().length() > classSizeLimit) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("script.too.large", codeUnit.getSource().getBody().substring(0, Math.min(classSizeLimit, 100))));
                return;
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (Field field : this.members.getFields()) {
                field.validate(symbols, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.validate(symbols, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.classType);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.classType).build();
        emitter.getTypeStack().push(clazz);
        try {
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            for (Field field : this.members.getFields()) {
                field.emit(emitter);
            }
            for (Property property : this.members.getProperties()) {
                property.emit(emitter);
            }
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            emitter.getProxyMethodTable().emit();
            this.additionalInfo.emit(emitter);
        }
        finally {
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(clazz.getClassWriter().toByteArray()).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.classType;
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

